/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application;

import com.ulcjava.applicationframework.application.IResourceConverter;
import com.ulcjava.applicationframework.application.ResourceMap;
import com.ulcjava.base.application.ClientContext;
import com.ulcjava.base.application.border.ULCAbstractBorder;
import com.ulcjava.base.application.border.ULCBevelBorder;
import com.ulcjava.base.application.border.ULCCompoundBorder;
import com.ulcjava.base.application.border.ULCEmptyBorder;
import com.ulcjava.base.application.border.ULCEtchedBorder;
import com.ulcjava.base.application.border.ULCLineBorder;
import com.ulcjava.base.application.border.ULCMatteBorder;
import com.ulcjava.base.application.border.ULCSoftBevelBorder;
import com.ulcjava.base.application.border.ULCTitledBorder;
import com.ulcjava.base.application.datatype.IDataType;
import com.ulcjava.base.application.datatype.ULCAbstractDataType;
import com.ulcjava.base.application.datatype.ULCDateDataType;
import com.ulcjava.base.application.datatype.ULCNumberDataType;
import com.ulcjava.base.application.datatype.ULCPercentDataType;
import com.ulcjava.base.application.datatype.ULCRegularExpressionDataType;
import com.ulcjava.base.application.datatype.ULCStringDataType;
import com.ulcjava.base.application.util.Color;
import com.ulcjava.base.application.util.Dimension;
import com.ulcjava.base.application.util.Font;
import com.ulcjava.base.application.util.Insets;
import com.ulcjava.base.application.util.KeyStroke;
import com.ulcjava.base.application.util.Point;
import com.ulcjava.base.application.util.ULCIcon;
import com.ulcjava.base.server.ULCResourceBorder;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceConverter<T>
implements IResourceConverter<T> {
    private static Map<Class<?>, IResourceConverter<?>> sConverters;
    private final Class<T> fType;
    private static final String COMMA_MASK = "qqqqqqqqqqqqqqqqqqwwwwwwwwwwwwwwwwwwwwwwwwwww";

    protected AbstractResourceConverter(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        this.fType = type;
    }

    @Override
    public Class<T> getType() {
        return this.fType;
    }

    @Override
    public T parseString(String s, ResourceMap r2) throws ResourceConverterException {
        if (s == null) {
            throw new ResourceConverterException("string must not be null", s);
        }
        if (s.trim().length() == 0) {
            throw new ResourceConverterException("string must not be empty", s);
        }
        return this.doParseString(s.trim(), r2);
    }

    public abstract T doParseString(String var1, ResourceMap var2) throws ResourceConverterException;

    public static void register(IResourceConverter<?> abstractResourceConverter) {
        if (abstractResourceConverter == null) {
            throw new IllegalArgumentException("resourceConverter must not be null");
        }
        sConverters.put(abstractResourceConverter.getType(), abstractResourceConverter);
    }

    public static IResourceConverter<?> forType(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (type.isPrimitive()) {
            type = AbstractResourceConverter.getObjectType(type);
        }
        return sConverters.get(type);
    }

    private static Class<?> getObjectType(Class<?> type) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        return type;
    }

    private static String[] splitIntoParameters(String parameterString) {
        String[] parameter = (parameterString = parameterString.replaceAll("\\\\,", COMMA_MASK)).length() == 0 ? new String[]{} : parameterString.split(",");
        for (int i2 = 0; i2 < parameter.length; ++i2) {
            parameter[i2] = parameter[i2].trim().replaceAll(COMMA_MASK, ",");
        }
        return parameter;
    }

    protected int intParameter(String parameter, ResourceMap r2) throws ResourceConverterException {
        IResourceConverter<Integer> intConverter = AbstractResourceConverter.forType(Integer.class);
        return intConverter.parseString(parameter, r2);
    }

    protected double doubleParameter(String parameter, ResourceMap r2) throws ResourceConverterException {
        IResourceConverter<Double> doubleConverter = AbstractResourceConverter.forType(Double.class);
        return doubleConverter.parseString(parameter, r2);
    }

    protected Insets insetsParameter(String parameter, ResourceMap r2) throws ResourceConverterException {
        IResourceConverter<Insets> insetsConverter = AbstractResourceConverter.forType(Insets.class);
        return insetsConverter.parseString(parameter, r2);
    }

    protected ULCAbstractBorder borderParameter(String parameter, ResourceMap r2) throws ResourceConverterException {
        IResourceConverter<ULCAbstractBorder> borderConverter = AbstractResourceConverter.forType(ULCAbstractBorder.class);
        return borderConverter.parseString(parameter, r2);
    }

    protected ULCIcon iconParameter(String parameter, ResourceMap r2) throws ResourceConverterException {
        IResourceConverter<ULCIcon> iconConverter = AbstractResourceConverter.forType(ULCIcon.class);
        return iconConverter.parseString(parameter, r2);
    }

    protected Font fontParameter(String parameter, ResourceMap r2) throws ResourceConverterException {
        IResourceConverter<Font> fontConverter = AbstractResourceConverter.forType(Font.class);
        return fontConverter.parseString(parameter, r2);
    }

    protected Color colorParameter(String parameter, ResourceMap r2) throws ResourceConverterException {
        IResourceConverter<Color> colorConverter = AbstractResourceConverter.forType(Color.class);
        return colorConverter.parseString(parameter, r2);
    }

    protected Boolean booleanParameter(String parameter, ResourceMap r2) throws ResourceConverterException {
        IResourceConverter<Boolean> booleanConverter = AbstractResourceConverter.forType(Boolean.class);
        return booleanConverter.parseString(parameter, r2);
    }

    static {
        IResourceConverter[] standardConverters;
        sConverters = new HashMap();
        for (IResourceConverter resourceConverter : standardConverters = new IResourceConverter[]{new BooleanResourceConverter("true", "on", "yes"), new IntegerResourceConverter(), new ByteResourceConverter(), new ShortResourceConverter(), new FontResourceConverter(), new LongResourceConverter(), new FloatResourceConverter(), new DoubleResourceConverter(), new ColorResourceConverter(), new ULCIconConverter(), new PointResourceConverter(), new DimensionResourceConverter(), new KeyStrokeResourceConverter(), new ULCBorderConverter(), new ULCDataTypeConverter(), new InsetResourceConverter()}) {
            AbstractResourceConverter.register(resourceConverter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ULCBorderConverter
    extends AbstractResourceConverter<ULCAbstractBorder> {
        protected ULCBorderConverter() {
            super(ULCAbstractBorder.class);
        }

        @Override
        public ULCAbstractBorder doParseString(String s, ResourceMap r2) throws ResourceConverterException {
            ULCBorderTypes type;
            String parameterString;
            String typeString;
            int openIndex = (s = s.trim()).indexOf(40);
            if (openIndex < 0) {
                typeString = s;
                parameterString = "";
            } else {
                typeString = s.substring(0, openIndex).trim();
                if (s.charAt(s.length() - 1) != ')') {
                    throw new ResourceConverterException("Missing closing ) ", s);
                }
                parameterString = s.substring(openIndex + 1, s.length() - 1).trim();
            }
            try {
                type = ULCBorderTypes.valueOf(typeString.toUpperCase());
            }
            catch (Exception e2) {
                throw new ResourceConverterException("Unknown border type ", s, e2);
            }
            switch (type) {
                case RESOURCE: {
                    if (parameterString.length() <= 0) {
                        throw new ResourceConverterException("Parameters missing", s);
                    }
                    return new ULCResourceBorder(parameterString);
                }
                case EMPTY: {
                    return new ULCEmptyBorder(this.insetsParameter(parameterString, r2));
                }
                case LINE: {
                    return this.createLineBorder(s, r2, parameterString);
                }
                case ETCHED: {
                    return this.createEtchedBorder(s, r2, parameterString);
                }
                case MATTE: {
                    return this.createMatteBorder(s, r2, parameterString);
                }
                case BEVEL: {
                    return this.createBevelBorder(s, r2, parameterString);
                }
                case SOFTBEVEL: {
                    return this.createSoftBevelBorder(s, r2, parameterString);
                }
                case TITLED: {
                    return this.createTitledBorder(s, r2, parameterString);
                }
                case COMPOUND: {
                    return this.createCompoundBorder(s, r2, parameterString);
                }
            }
            throw new ResourceConverterException("Unmapped border type ", s);
        }

        private ULCSoftBevelBorder createSoftBevelBorder(String s, ResourceMap r2, String parameterString) throws ResourceConverterException {
            String[] parameter = parameterString.length() == 0 ? new String[]{} : parameterString.split(",");
            switch (parameter.length) {
                case 1: {
                    return new ULCSoftBevelBorder(this.intParameter(parameter[0], r2));
                }
                case 3: {
                    return new ULCSoftBevelBorder(this.intParameter(parameter[0], r2), this.colorParameter(parameter[1], r2), this.colorParameter(parameter[2], r2));
                }
                case 5: {
                    return new ULCSoftBevelBorder(this.intParameter(parameter[0], r2), this.colorParameter(parameter[1], r2), this.colorParameter(parameter[2], r2), this.colorParameter(parameter[3], r2), this.colorParameter(parameter[4], r2));
                }
            }
            throw new ResourceConverterException("Illegal number of parameters ", s);
        }

        private ULCBevelBorder createBevelBorder(String s, ResourceMap r2, String parameterString) throws ResourceConverterException {
            String[] parameter = parameterString.length() == 0 ? new String[]{} : parameterString.split(",");
            switch (parameter.length) {
                case 1: {
                    return new ULCBevelBorder(this.intParameter(parameter[0], r2));
                }
                case 3: {
                    return new ULCBevelBorder(this.intParameter(parameter[0], r2), this.colorParameter(parameter[1], r2), this.colorParameter(parameter[2], r2));
                }
                case 5: {
                    return new ULCBevelBorder(this.intParameter(parameter[0], r2), this.colorParameter(parameter[1], r2), this.colorParameter(parameter[2], r2), this.colorParameter(parameter[3], r2), this.colorParameter(parameter[4], r2));
                }
            }
            throw new ResourceConverterException("Illegal number of parameters ", s);
        }

        private ULCTitledBorder createTitledBorder(String s, ResourceMap r2, String parameterString) throws ResourceConverterException {
            String[] parameter;
            if (parameterString == null || parameterString.trim().length() == 0) {
                throw new ResourceConverterException("No parameter", s);
            }
            int openIndex = parameterString.indexOf(40);
            String borderParam = null;
            String followingParam = parameterString;
            ULCAbstractBorder borderParameter = null;
            if (openIndex < 0 || s.indexOf(44) < openIndex) {
                String[] param = AbstractResourceConverter.splitIntoParameters(followingParam);
                try {
                    borderParameter = this.borderParameter(param[0], r2);
                    parameter = new String[param.length - 1];
                    System.arraycopy(param, 1, parameter, 0, parameter.length);
                }
                catch (Exception e2) {
                    parameter = param;
                }
            } else {
                String typeString = parameterString.substring(0, openIndex).trim();
                int endIndex = -1;
                try {
                    ULCBorderTypes.valueOf(typeString.toUpperCase());
                    endIndex = this.findClosing(openIndex, parameterString);
                    borderParam = parameterString.substring(0, endIndex + 1);
                }
                catch (Exception e3) {
                    // empty catch block
                }
                if (borderParam != null) {
                    borderParameter = this.borderParameter(borderParam, r2);
                    int k2 = parameterString.indexOf(44, endIndex + 1);
                    if (k2 < 0) {
                        throw new ResourceConverterException("Illegal number of parameter", s);
                    }
                    followingParam = parameterString.substring(k2 + 1, parameterString.length()).trim();
                }
                parameter = AbstractResourceConverter.splitIntoParameters(followingParam);
            }
            switch (parameter.length) {
                case 1: {
                    if (borderParameter == null) {
                        return new ULCTitledBorder(parameter[0]);
                    }
                    return new ULCTitledBorder(borderParameter, parameter[0]);
                }
                case 3: {
                    return new ULCTitledBorder(borderParameter, parameter[0], this.intParameter(parameter[1], r2), this.intParameter(parameter[2], r2));
                }
                case 4: {
                    return new ULCTitledBorder(borderParameter, parameter[0], this.intParameter(parameter[1], r2), this.intParameter(parameter[2], r2), this.fontParameter(parameter[3], r2));
                }
                case 5: {
                    return new ULCTitledBorder(borderParameter, parameter[0], this.intParameter(parameter[1], r2), this.intParameter(parameter[2], r2), this.fontParameter(parameter[3], r2), this.colorParameter(parameter[4], r2));
                }
            }
            throw new ResourceConverterException("Illegal number of parameter", s);
        }

        private ULCCompoundBorder createCompoundBorder(String s, ResourceMap r2, String parameterString) throws ResourceConverterException {
            String firstParam;
            if (parameterString == null || parameterString.trim().length() == 0) {
                throw new ResourceConverterException("No parameter", s);
            }
            int openIndex = parameterString.indexOf(40);
            int commaIndex = parameterString.indexOf(44);
            if (commaIndex < 0) {
                throw new ResourceConverterException("no border parameter found ", s);
            }
            if (openIndex > 0 && openIndex < commaIndex) {
                int endIndex = this.findClosing(openIndex, parameterString);
                firstParam = parameterString.substring(0, endIndex + 1);
                commaIndex = parameterString.indexOf(44, endIndex + 1);
                if (commaIndex < 0) {
                    throw new ResourceConverterException("Illegal number of parameter", s);
                }
            } else {
                firstParam = parameterString.substring(0, commaIndex);
            }
            String secondParam = parameterString.substring(commaIndex + 1, parameterString.length()).trim();
            return new ULCCompoundBorder(this.borderParameter(firstParam, r2), this.borderParameter(secondParam, r2));
        }

        private int findClosing(int openIndex, String s) {
            int index = openIndex + 1;
            while (index < s.length() && s.charAt(index) != ')') {
                if (s.charAt(index) == '(') {
                    index = this.findClosing(index, s) + 1;
                    continue;
                }
                ++index;
            }
            return index;
        }

        private ULCMatteBorder createMatteBorder(String s, ResourceMap r2, String parameterString) throws ResourceConverterException {
            String[] parameter = parameterString.length() == 0 ? new String[]{} : parameterString.split(",");
            switch (parameter.length) {
                case 2: 
                case 3: 
                case 5: {
                    String insetsParamString = parameterString.substring(0, parameterString.lastIndexOf(44));
                    try {
                        return new ULCMatteBorder(this.insetsParameter(insetsParamString, r2), this.colorParameter(parameter[parameter.length - 1], r2));
                    }
                    catch (Exception e2) {
                        return new ULCMatteBorder(this.insetsParameter(insetsParamString, r2), this.iconParameter(parameter[parameter.length - 1], r2));
                    }
                }
            }
            throw new ResourceConverterException("Illegal number of parameter", s);
        }

        private ULCEtchedBorder createEtchedBorder(String s, ResourceMap r2, String parameterString) throws ResourceConverterException {
            String[] parameter = parameterString.length() == 0 ? new String[]{} : parameterString.split(",");
            switch (parameter.length) {
                case 0: {
                    return new ULCEtchedBorder();
                }
                case 1: {
                    return new ULCEtchedBorder(this.intParameter(parameter[0], r2));
                }
                case 2: {
                    return new ULCEtchedBorder(this.colorParameter(parameter[0], r2), this.colorParameter(parameter[1], r2));
                }
                case 3: {
                    return new ULCEtchedBorder(this.intParameter(parameter[0], r2), this.colorParameter(parameter[1], r2), this.colorParameter(parameter[2], r2));
                }
            }
            throw new ResourceConverterException("Illegal number of parameter", s);
        }

        private ULCLineBorder createLineBorder(String s, ResourceMap r2, String parameterString) throws ResourceConverterException {
            String[] parameter = parameterString.split(",");
            Color color = Color.black;
            int thickness = 1;
            boolean round = false;
            switch (parameter.length) {
                case 3: {
                    round = this.booleanParameter(parameter[2], r2);
                }
                case 2: {
                    thickness = this.intParameter(parameter[1], r2);
                }
                case 1: {
                    try {
                        color = this.colorParameter(parameter[0], r2);
                        break;
                    }
                    catch (ResourceConverterException e2) {
                        if (parameter.length == 1) {
                            thickness = this.intParameter(parameter[0], r2);
                            break;
                        }
                        throw e2;
                    }
                }
                default: {
                    throw new ResourceConverterException("Illegal number of parameter", s);
                }
            }
            return new ULCLineBorder(color, thickness, round);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum ULCBorderTypes {
            RESOURCE,
            EMPTY,
            LINE,
            ETCHED,
            MATTE,
            BEVEL,
            SOFTBEVEL,
            TITLED,
            COMPOUND;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ULCDataTypeConverter
    extends AbstractResourceConverter<IDataType> {
        protected ULCDataTypeConverter() {
            super(IDataType.class);
        }

        @Override
        public ULCAbstractDataType doParseString(String s, ResourceMap r2) throws ResourceConverterException {
            ULCDataTypeTypes type;
            String parameterString;
            String typeString;
            int openIndex = (s = s.trim()).indexOf(40);
            if (openIndex < 0) {
                typeString = s;
                parameterString = "";
            } else {
                typeString = s.substring(0, openIndex).trim();
                if (s.charAt(s.length() - 1) != ')') {
                    throw new ResourceConverterException("Missing closing ) ", s);
                }
                parameterString = s.substring(openIndex + 1, s.length() - 1).trim();
            }
            try {
                type = ULCDataTypeTypes.valueOf(typeString.toUpperCase());
            }
            catch (Exception e2) {
                throw new ResourceConverterException("Unknown data type type ", s, e2);
            }
            switch (type) {
                case STRING: {
                    return this.createStringDataType(s, r2, parameterString);
                }
                case REGEXP: 
                case REGULAREXPRESSION: {
                    return this.createRegexpDataType(s, r2, parameterString);
                }
                case PERCENT: {
                    return this.createPercentDataType(s, r2, parameterString);
                }
                case DATE: {
                    return this.createDateDataType(s, r2, parameterString);
                }
                case NUMBER: {
                    return this.createNumberDataType(s, r2, parameterString);
                }
            }
            throw new ResourceConverterException("Unmapped data type ", s);
        }

        private ULCNumberDataType createNumberDataType(String s, ResourceMap r2, String parameterString) throws ResourceConverterException {
            String[] parameter = AbstractResourceConverter.splitIntoParameters(parameterString);
            boolean secondParameterIsNumber = false;
            if (parameter.length > 1) {
                try {
                    this.doubleParameter(parameter[1], r2);
                    secondParameterIsNumber = true;
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            if (secondParameterIsNumber) {
                switch (parameter.length) {
                    case 0: {
                        return new ULCNumberDataType();
                    }
                    case 1: {
                        return new ULCNumberDataType(parameter[0], new DecimalFormatSymbols());
                    }
                    case 2: {
                        ULCNumberDataType dataType = new ULCNumberDataType(parameter[0], new DecimalFormatSymbols());
                        dataType.setRoundingMode(this.intParameter(parameter[1], r2));
                        return dataType;
                    }
                    case 3: {
                        ULCNumberDataType dataType = new ULCNumberDataType(parameter[0], new DecimalFormatSymbols());
                        dataType.setMin(this.doubleParameter(parameter[1], r2));
                        dataType.setMax(this.doubleParameter(parameter[2], r2));
                        return dataType;
                    }
                    case 4: {
                        ULCNumberDataType dataType = new ULCNumberDataType(parameter[0], new DecimalFormatSymbols());
                        dataType.setMin(this.doubleParameter(parameter[1], r2));
                        dataType.setMax(this.doubleParameter(parameter[2], r2));
                        dataType.setRoundingMode(this.intParameter(parameter[3], r2));
                        return dataType;
                    }
                }
                throw new ResourceConverterException("Illegal number of parameter", s);
            }
            switch (parameter.length) {
                case 0: {
                    return new ULCNumberDataType();
                }
                case 1: {
                    return new ULCNumberDataType(parameter[0], new DecimalFormatSymbols());
                }
                case 2: {
                    return new ULCNumberDataType(parameter[0], new DecimalFormatSymbols(this.parseLocale(parameter[1])));
                }
                case 3: {
                    ULCNumberDataType dataType = new ULCNumberDataType(parameter[0], new DecimalFormatSymbols(this.parseLocale(parameter[1])));
                    dataType.setRoundingMode(this.intParameter(parameter[2], r2));
                    return dataType;
                }
                case 4: {
                    ULCNumberDataType dataType = new ULCNumberDataType(parameter[0], new DecimalFormatSymbols(this.parseLocale(parameter[1])));
                    dataType.setMin(this.doubleParameter(parameter[2], r2));
                    dataType.setMax(this.doubleParameter(parameter[3], r2));
                    return dataType;
                }
                case 5: {
                    ULCNumberDataType dataType = new ULCNumberDataType(parameter[0], new DecimalFormatSymbols(this.parseLocale(parameter[1])));
                    dataType.setMin(this.doubleParameter(parameter[2], r2));
                    dataType.setMax(this.doubleParameter(parameter[3], r2));
                    dataType.setRoundingMode(this.intParameter(parameter[4], r2));
                    return dataType;
                }
            }
            throw new ResourceConverterException("Illegal number of parameter", s);
        }

        private ULCStringDataType createStringDataType(String s, ResourceMap r2, String parameterString) throws ResourceConverterException {
            String[] parameter = parameterString.length() == 0 ? new String[]{} : parameterString.split(",");
            switch (parameter.length) {
                case 0: {
                    return new ULCStringDataType();
                }
                case 1: {
                    return new ULCStringDataType(this.intParameter(parameter[0], r2));
                }
                case 2: {
                    return new ULCStringDataType(this.intParameter(parameter[0], r2), this.intParameter(parameter[1], r2));
                }
                case 3: {
                    ULCStringDataType dataType = new ULCStringDataType(this.intParameter(parameter[0], r2), this.intParameter(parameter[1], r2));
                    dataType.setIgnoreLongStringCompeletely(this.booleanParameter(parameter[2], r2));
                    return dataType;
                }
            }
            throw new ResourceConverterException("Illegal number of parameter", s);
        }

        private ULCDateDataType createDateDataType(String s, ResourceMap r2, String parameterString) throws ResourceConverterException {
            String[] parameter = parameterString.length() == 0 ? new String[]{} : parameterString.split(",");
            switch (parameter.length) {
                case 0: {
                    return new ULCDateDataType();
                }
                case 1: {
                    return new ULCDateDataType(parameter[0]);
                }
                case 2: {
                    ULCDateDataType dataType = new ULCDateDataType(parameter[0]);
                    dataType.setTwoDigitYearStart(new GregorianCalendar(this.intParameter(parameter[1], r2), 0, 1).getTime());
                    return dataType;
                }
            }
            throw new ResourceConverterException("Illegal number of parameter", s);
        }

        private ULCPercentDataType createPercentDataType(String s, ResourceMap r2, String parameterString) throws ResourceConverterException {
            String[] parameter;
            String[] stringArray = parameter = parameterString.length() == 0 ? new String[]{} : parameterString.split(",");
            if (parameter.length == 0) {
                return new ULCPercentDataType();
            }
            Locale locale = null;
            try {
                this.intParameter(parameter[0], r2);
            }
            catch (Exception e2) {
                locale = this.parseLocale(parameter[0]);
            }
            if (locale == null) {
                switch (parameter.length) {
                    case 1: {
                        return new ULCPercentDataType(this.intParameter(parameter[0], r2));
                    }
                    case 2: {
                        ULCPercentDataType dataType = new ULCPercentDataType(this.intParameter(parameter[0], r2));
                        try {
                            dataType.setRoundingMode(this.intParameter(parameter[1], r2));
                        }
                        catch (Exception e3) {
                            dataType.setGroupingUsed(this.booleanParameter(parameter[1], r2));
                        }
                        return dataType;
                    }
                    case 3: {
                        ULCPercentDataType dataType = new ULCPercentDataType(this.intParameter(parameter[0], r2));
                        dataType.setRoundingMode(this.intParameter(parameter[1], r2));
                        dataType.setGroupingUsed(this.booleanParameter(parameter[2], r2));
                        return dataType;
                    }
                }
                throw new ResourceConverterException("Illegal number of parameter", s);
            }
            switch (parameter.length) {
                case 1: {
                    return new ULCPercentDataType(locale);
                }
                case 2: {
                    return new ULCPercentDataType(locale, this.intParameter(parameter[1], r2));
                }
                case 3: {
                    ULCPercentDataType dataType = new ULCPercentDataType(locale, this.intParameter(parameter[1], r2));
                    try {
                        dataType.setRoundingMode(this.intParameter(parameter[2], r2));
                    }
                    catch (Exception e4) {
                        dataType.setGroupingUsed(this.booleanParameter(parameter[2], r2));
                    }
                    return dataType;
                }
                case 4: {
                    ULCPercentDataType dataType = new ULCPercentDataType(locale, this.intParameter(parameter[1], r2));
                    dataType.setRoundingMode(this.intParameter(parameter[2], r2));
                    dataType.setGroupingUsed(this.booleanParameter(parameter[3], r2));
                    return dataType;
                }
            }
            throw new ResourceConverterException("Illegal number of parameter", s);
        }

        private Locale parseLocale(String parameter) throws ResourceConverterException {
            String[] localeParams = parameter.split("-");
            switch (localeParams.length) {
                case 1: {
                    return new Locale(localeParams[0]);
                }
                case 2: {
                    return new Locale(localeParams[0], localeParams[1]);
                }
                case 3: {
                    return new Locale(localeParams[0], localeParams[1], localeParams[2]);
                }
            }
            throw new ResourceConverterException("Cannot create Locale", parameter);
        }

        private ULCRegularExpressionDataType createRegexpDataType(String s, ResourceMap r2, String parameterString) throws ResourceConverterException {
            String[] parameter = AbstractResourceConverter.splitIntoParameters(parameterString);
            switch (parameter.length) {
                case 0: {
                    return new ULCRegularExpressionDataType();
                }
                case 1: {
                    return new ULCRegularExpressionDataType(parameter[0]);
                }
                case 2: {
                    return new ULCRegularExpressionDataType(parameter[0], parameter[1]);
                }
            }
            throw new ResourceConverterException("Illegal number of parameter", s);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum ULCDataTypeTypes {
            STRING,
            REGEXP,
            REGULAREXPRESSION,
            PERCENT,
            DATE,
            NUMBER;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ULCIconConverter
    extends AbstractResourceConverter<ULCIcon> {
        protected ULCIconConverter() {
            super(ULCIcon.class);
        }

        @Override
        public ULCIcon doParseString(String s, ResourceMap r2) throws ResourceConverterException {
            if (r2 == null) {
                throw new ResourceConverterException("resourceMap must not be null", s);
            }
            URL iconURL = r2.getClassLoader().getResource(r2.getResourcesDir() + s);
            while (iconURL == null && r2.getParent() != null) {
                r2 = r2.getParent();
                iconURL = r2.getClassLoader().getResource(r2.getResourcesDir() + s);
            }
            if (iconURL == null) {
                throw new ResourceConverterException("Not a valid url", s);
            }
            ULCIcon icon = new ULCIcon(iconURL);
            return icon;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColorResourceConverter
    extends AbstractResourceConverter<Color> {
        public ColorResourceConverter() {
            super(Color.class);
        }

        @Override
        public Color doParseString(String s, ResourceMap r2) throws ResourceConverterException {
            if (s.startsWith("#")) {
                return this.parseHexCode(s);
            }
            if (s.contains(",")) {
                return this.parseCommaSeparated(s);
            }
            return this.parseConstant(s);
        }

        private Color parseConstant(String s) throws ResourceConverterException {
            try {
                Field constantColor = Color.class.getDeclaredField(s);
                return (Color)constantColor.get(null);
            }
            catch (Exception e2) {
                throw new ResourceConverterException("No color found for ", s, e2);
            }
        }

        private Color parseHexCode(String s) throws ResourceConverterException {
            String hexDigit = "[0-9a-fA-F]";
            if (s.matches("#(?:" + hexDigit + hexDigit + "){3}(" + hexDigit + hexDigit + ")?")) {
                String numbers = s.substring(1);
                int paramCount = numbers.length() == 6 ? 3 : 4;
                int[] ints = new int[paramCount];
                for (int i2 = 0; i2 < paramCount; ++i2) {
                    try {
                        ints[i2] = Integer.parseInt(numbers.substring(i2 * 2, i2 * 2 + 2), 16);
                        continue;
                    }
                    catch (NumberFormatException e2) {
                        throw new ResourceConverterException("Illegal characters in ", s, e2);
                    }
                }
                if (paramCount == 4) {
                    ints = new int[]{ints[1], ints[2], ints[3], ints[0]};
                }
                return this.createColor(s, ints);
            }
            throw new ResourceConverterException("No color found for ", s);
        }

        private Color parseCommaSeparated(String s) throws ResourceConverterException {
            String[] numbers = s.split(",");
            if (numbers.length != 3 && numbers.length != 4) {
                throw new ResourceConverterException("Color needs three(r,g,b) or four (r,g,b,a) parameters ", s);
            }
            int[] ints = new int[numbers.length];
            for (int i2 = 0; i2 < ints.length; ++i2) {
                try {
                    ints[i2] = Integer.parseInt(numbers[i2]);
                    continue;
                }
                catch (NumberFormatException e2) {
                    throw new ResourceConverterException("Illegal characters in ", s, e2);
                }
            }
            return this.createColor(s, ints);
        }

        private Color createColor(String s, int ... i2) throws ResourceConverterException {
            try {
                if (i2.length == 4) {
                    return new Color(i2[0], i2[1], i2[2], i2[3]);
                }
                return new Color(i2[0], i2[1], i2[2]);
            }
            catch (IllegalArgumentException e2) {
                throw new ResourceConverterException("Color needs three(r,g,b) or four (r,g,b,a) positive values in the range of 0 and 255 ", s, e2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FontResourceConverter
    extends AbstractResourceConverter<Font> {
        private static final int DEFAULT_STYLE = 0;
        private static final int DEFAULT_SIZE = 12;

        protected FontResourceConverter() {
            super(Font.class);
        }

        @Override
        public Font doParseString(String s, ResourceMap r2) throws ResourceConverterException {
            Font font = null;
            font = this.parse(s, ' ');
            if (font == null) {
                font = this.parse(s, '-');
            }
            if (font == null) {
                font = new Font(s, 0, 12);
            }
            return font;
        }

        private Font parse(String s, char delimiter) {
            Font font = null;
            String[] blankSplited = s.split(new Character(delimiter).toString());
            String name = null;
            int size = 0;
            int style = -1;
            if (blankSplited.length > 1) {
                size = this.parseSize(blankSplited[blankSplited.length - 1]);
                if (size > 0) {
                    if (blankSplited.length == 2) {
                        name = blankSplited[0];
                        style = 0;
                    } else {
                        style = this.parseStyle(blankSplited[blankSplited.length - 2]);
                        if (style >= 0) {
                            name = this.startToSecondLast(s, delimiter);
                        } else {
                            style = 0;
                            name = this.startToLast(s, delimiter);
                        }
                    }
                } else {
                    style = this.parseStyle(blankSplited[blankSplited.length - 1]);
                    if (style >= 0) {
                        name = this.startToLast(s, delimiter);
                        size = 12;
                    }
                }
            }
            if (name != null) {
                if (name.trim().length() == 0) {
                    name = "Default";
                }
                font = new Font(name, style, size);
            }
            return font;
        }

        private String startToSecondLast(String s, char delimiter) {
            return this.startToLast(this.startToLast(s, delimiter), delimiter);
        }

        private String startToLast(String s, char delimiter) {
            return s.substring(0, s.lastIndexOf(delimiter));
        }

        private int parseStyle(String possibleStyle) {
            int style = -1;
            try {
                FontStyle styleCode = FontStyle.valueOf(possibleStyle.toUpperCase());
                style = styleCode.getStyle();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return style;
        }

        private int parseSize(String possibleSize) {
            int size = 0;
            try {
                size = Integer.parseInt(possibleSize);
            }
            catch (NumberFormatException nfe) {
                size = 0;
            }
            return size;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum FontStyle {
            PLAIN(0),
            BOLD(1),
            ITALIC(2),
            BOLDITALIC(3);

            private final int fStyle;

            private FontStyle(int style) {
                this.fStyle = style;
            }

            public int getStyle() {
                return this.fStyle;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyStrokeResourceConverter
    extends AbstractResourceConverter<KeyStroke> {
        protected KeyStrokeResourceConverter() {
            super(KeyStroke.class);
        }

        @Override
        public KeyStroke doParseString(String s, ResourceMap r2) throws ResourceConverterException {
            try {
                s = s.replace("shortcut", ClientContext.getMenuShortcutKeyMask() == 4 ? "meta" : "control");
                s = s.substring(0, s.length() - 1) + s.substring(s.length() - 1).toUpperCase();
                return KeyStroke.getKeyStroke(s);
            }
            catch (Exception e2) {
                throw new ResourceConverterException("Could not convert to " + this.getType().getSimpleName(), s, e2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InsetResourceConverter
    extends AbstractIntegerListResourceConverter<Insets> {
        protected InsetResourceConverter() {
            super(Insets.class, 4, 2, 1);
        }

        @Override
        protected Insets createObject(Integer[] parameters) {
            switch (parameters.length) {
                case 1: {
                    return new Insets(parameters[0], parameters[0], parameters[0], parameters[0]);
                }
                case 2: {
                    return new Insets(parameters[0], parameters[1], parameters[0], parameters[1]);
                }
            }
            return new Insets(parameters[0], parameters[1], parameters[2], parameters[3]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DimensionResourceConverter
    extends AbstractIntegerListResourceConverter<Dimension> {
        protected DimensionResourceConverter() {
            super(Dimension.class, 2);
        }

        @Override
        protected Dimension createObject(Integer[] parameters) {
            return new Dimension(parameters[0], parameters[1]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PointResourceConverter
    extends AbstractIntegerListResourceConverter<Point> {
        protected PointResourceConverter() {
            super(Point.class, 2);
        }

        @Override
        protected Point createObject(Integer[] parameters) {
            return new Point(parameters[0], parameters[1]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractIntegerListResourceConverter<T>
    extends AbstractResourceConverter<T> {
        private final int[] fNumberOfParameters;

        protected AbstractIntegerListResourceConverter(Class<T> type, int ... numberOfParameters) {
            super(type);
            this.fNumberOfParameters = numberOfParameters;
        }

        @Override
        public T doParseString(String s, ResourceMap r2) throws ResourceConverterException {
            String[] paramStrings = s.split(",");
            if (!this.isLegalNumberOfParameters(paramStrings.length)) {
                throw new ResourceConverterException(this.getType().getSimpleName() + " needs " + this.printLegalNumbers() + " parameter", s);
            }
            Integer[] parameters = new Integer[paramStrings.length];
            for (int i2 = 0; i2 < paramStrings.length; ++i2) {
                parameters[i2] = this.intParameter(paramStrings[i2], r2);
            }
            return this.createObject(parameters);
        }

        private String printLegalNumbers() {
            String result = "";
            for (int i2 = 0; i2 < this.fNumberOfParameters.length; ++i2) {
                result = i2 < this.fNumberOfParameters.length - 2 ? result + this.fNumberOfParameters[i2] + "," : (i2 < this.fNumberOfParameters.length - 1 ? result + this.fNumberOfParameters[i2] + " or " : result + this.fNumberOfParameters[i2]);
            }
            return result;
        }

        private boolean isLegalNumberOfParameters(int number) {
            for (int i2 = 0; i2 < this.fNumberOfParameters.length; ++i2) {
                if (number != this.fNumberOfParameters[i2]) continue;
                return true;
            }
            return false;
        }

        protected abstract T createObject(Integer[] var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BooleanResourceConverter
    extends AbstractResourceConverter<Boolean> {
        private final List<String> fTrueStrings;

        protected BooleanResourceConverter(String ... trueStrings) {
            super(Boolean.class);
            this.fTrueStrings = new ArrayList<String>(trueStrings.length);
            for (String trueString : trueStrings) {
                this.fTrueStrings.add(trueString.toUpperCase());
            }
        }

        @Override
        public Boolean doParseString(String s, ResourceMap r2) throws ResourceConverterException {
            return this.fTrueStrings.contains(s.toUpperCase());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleResourceConverter
    extends AbstractNumberResourceConverter<Double> {
        protected DoubleResourceConverter() {
            super(Double.class);
        }

        @Override
        protected Double parseNumber(String s) {
            return Double.parseDouble(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatResourceConverter
    extends AbstractNumberResourceConverter<Float> {
        protected FloatResourceConverter() {
            super(Float.class);
        }

        @Override
        protected Float parseNumber(String s) {
            return Float.valueOf(Float.parseFloat(s));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongResourceConverter
    extends AbstractNumberResourceConverter<Long> {
        protected LongResourceConverter() {
            super(Long.class);
        }

        @Override
        protected Long parseNumber(String s) {
            return Long.parseLong(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShortResourceConverter
    extends AbstractNumberResourceConverter<Short> {
        protected ShortResourceConverter() {
            super(Short.class);
        }

        @Override
        protected Short parseNumber(String s) {
            return Short.parseShort(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteResourceConverter
    extends AbstractNumberResourceConverter<Byte> {
        protected ByteResourceConverter() {
            super(Byte.class);
        }

        @Override
        protected Byte parseNumber(String s) {
            return Byte.parseByte(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegerResourceConverter
    extends AbstractNumberResourceConverter<Integer> {
        protected IntegerResourceConverter() {
            super(Integer.class);
        }

        @Override
        protected Integer parseNumber(String s) {
            return Integer.parseInt(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractNumberResourceConverter<T extends Number>
    extends AbstractResourceConverter<T> {
        protected AbstractNumberResourceConverter(Class<T> numberClass) {
            super(numberClass);
        }

        @Override
        public final T doParseString(String s, ResourceMap r2) throws ResourceConverterException {
            T result = null;
            try {
                result = this.parseNumber(s);
            }
            catch (NumberFormatException e2) {
                throw new ResourceConverterException("Could not convert to " + this.getType().getSimpleName(), s, e2);
            }
            return result;
        }

        protected abstract T parseNumber(String var1);
    }

    public static class ResourceConverterException
    extends Exception {
        public ResourceConverterException(String message, String badString, Throwable cause) {
            super(message + " string: \"" + ResourceConverterException.shorten(badString) + "\"", cause);
        }

        private static String shorten(String string) {
            return string.length() <= 128 ? string : string.substring(0, 127) + "... (+" + (string.length() - 128) + " characters)";
        }

        public ResourceConverterException(String message, String badString) {
            this(message, badString, null);
        }
    }
}

