/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application;

import com.ulcjava.applicationframework.application.Application;
import com.ulcjava.applicationframework.application.ApplicationActionMap;
import com.ulcjava.applicationframework.application.ApplicationContext;
import com.ulcjava.applicationframework.application.MnemonicTextUtils;
import com.ulcjava.applicationframework.application.ResourceMap;
import com.ulcjava.base.application.AbstractAction;
import com.ulcjava.base.application.IAction;
import com.ulcjava.base.application.event.ActionEvent;
import com.ulcjava.base.application.util.KeyStroke;
import com.ulcjava.base.application.util.ULCIcon;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationAction
extends AbstractAction
implements PropertyChangeListener,
Serializable {
    private static final String ACTION_PREFIX = ".Action.";
    private static final String ACTION_TEXT = ".Action.text";
    private static final String ACTION_SHORT_DESCRIPTION = ".Action.shortDescription";
    private static final String ACTION_LONG_DESCRIPTION = ".Action.longDescription";
    private static final String ACTION_ACCELERATOR = ".Action.accelerator";
    private static final String ACTION_ICON = ".Action.icon";
    private static final String ACTION_COMMAND = ".Action.command";
    private static final String ACTION_MNEMONIC = ".Action.mnemonic";
    private static final Logger LOG = Logger.getLogger(Application.class.getName());
    private final ApplicationActionMap fApplicationActionMap;
    private final ResourceMap fResourceMap;
    private final String fActionName;
    private transient Method fActionMethod;
    private final String fEnabledProperty;
    private final Object fActionTarget;
    private transient Method fEnabledPropertyReadMethod;
    private transient Method fEnabledPropertyWriteMethod;

    public ApplicationAction(ApplicationActionMap applicationActionMap, ResourceMap resourceMap, String actionName, Method actionMethod, String enabledProperty) {
        if (applicationActionMap == null) {
            throw new IllegalArgumentException("applicationActionMap must not be null");
        }
        if (actionName == null) {
            throw new IllegalArgumentException("actionName must not be null");
        }
        if (actionMethod == null) {
            throw new IllegalArgumentException("actionMethod must not be null");
        }
        this.fApplicationActionMap = applicationActionMap;
        this.fActionTarget = applicationActionMap.getActionsObject();
        this.fResourceMap = resourceMap;
        this.fActionName = actionName;
        this.fActionMethod = actionMethod;
        this.fEnabledProperty = enabledProperty;
        if (this.fEnabledProperty != null) {
            this.installEnabledBinding();
        } else {
            this.fEnabledPropertyReadMethod = null;
            this.fEnabledPropertyWriteMethod = null;
        }
        this.initProperties();
    }

    private void installEnabledBinding() {
        Object actionsObject = this.getApplicationActionMap().getActionsObject();
        this.installMethods(actionsObject);
        this.installPCL(actionsObject);
    }

    private void installPCL(Object actionsObject) {
        Class<?> actionsClass = actionsObject.getClass();
        Method addPCLMethod = null;
        try {
            addPCLMethod = actionsClass.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            addPCLMethod.invoke(actionsObject, this);
        }
        catch (Exception e2) {
            this.enablingPropertyError("PropertyChangeListener could not be installed", e2);
        }
    }

    private void installMethods(Object actionsObject) {
        PropertyDescriptor enablingProperty = null;
        try {
            enablingProperty = PropertyUtils.getPropertyDescriptor((Object)actionsObject, (String)this.getEnabledProperty());
        }
        catch (Exception e2) {
            this.enablingPropertyError("Enabling property could not be accessed", e2);
        }
        if (enablingProperty != null) {
            if (this.isBoolean(enablingProperty.getPropertyType())) {
                Method enablingPropertyReadMethod = PropertyUtils.getReadMethod((PropertyDescriptor)enablingProperty);
                if (enablingPropertyReadMethod == null) {
                    this.enablingPropertyError("Enabling property must be readable");
                }
                this.setEnabledPropertyReadMethod(enablingPropertyReadMethod);
                this.setEnabledPropertyWriteMethod(PropertyUtils.getWriteMethod((PropertyDescriptor)enablingProperty));
            } else {
                this.enablingPropertyError("Enabling property must be of Type Boolean");
            }
        }
    }

    private void enablingPropertyError(String message) {
        this.enablingPropertyError(message, null);
    }

    private void enablingPropertyError(String message, Throwable cause) {
        throw new IllegalArgumentException(message, cause);
    }

    private boolean isBoolean(Class<?> propertyType) {
        return propertyType == Boolean.class || propertyType == Boolean.TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setEnabled(boolean enabled) {
        Method enabledPropertyWriteMethod = this.getEnabledPropertyWriteMethod();
        if (enabledPropertyWriteMethod == null) {
            if (this.getEnabledPropertyReadMethod() != null) throw new Error("Enabled Property should not be set - because enabling Property is read only");
            super.setEnabled(enabled);
            return;
        }
        Object actionsObject = this.getApplicationActionMap().getActionsObject();
        try {
            enabledPropertyWriteMethod.invoke(actionsObject, enabled);
            return;
        }
        catch (Exception e2) {
            String msg = String.format("%s.%s(%s) failed", actionsObject.getClass(), enabledPropertyWriteMethod, enabled);
            throw new Error("Error on setting enabled property : " + msg, e2);
        }
    }

    @Override
    public boolean isEnabled() {
        Method enabledPropertyReadMethod = this.getEnabledPropertyReadMethod();
        if (enabledPropertyReadMethod == null) {
            return super.isEnabled();
        }
        Object actionsObject = this.getApplicationActionMap().getActionsObject();
        try {
            return (Boolean)enabledPropertyReadMethod.invoke(actionsObject, new Object[0]);
        }
        catch (Exception e2) {
            String msg = String.format("%s.%s() failed", actionsObject.getClass(), enabledPropertyReadMethod);
            throw new Error("Error on getting enabled property : " + msg, e2);
        }
    }

    private void initProperties() {
        String name = this.getActionName();
        ResourceMap resourceMap = this.getResourceMap();
        if (resourceMap != null) {
            String command;
            Integer mnemonic;
            KeyStroke accelerator;
            ULCIcon icon;
            String longDesc;
            String shortDesc;
            String actionName = this.getActionName();
            String text = resourceMap.getString(actionName + ACTION_TEXT, new Object[0]);
            if (text != null) {
                name = text;
            }
            if ((shortDesc = resourceMap.getString(actionName + ACTION_SHORT_DESCRIPTION, new Object[0])) != null) {
                this.putValue("ShortDescription", shortDesc);
            }
            if ((longDesc = resourceMap.getString(actionName + ACTION_LONG_DESCRIPTION, new Object[0])) != null) {
                this.putValue("LongDescription", longDesc);
            }
            if ((icon = resourceMap.getULCIcon(actionName + ACTION_ICON)) != null) {
                this.putValue("SmallIcon", icon);
            }
            if ((accelerator = resourceMap.getKeyStroke(actionName + ACTION_ACCELERATOR)) != null) {
                this.putValue("AcceleratorKey", accelerator);
            }
            if ((mnemonic = resourceMap.getKeyCode(actionName + ACTION_MNEMONIC)) != null) {
                this.putValue("MnemonicKey", mnemonic);
            }
            if ((command = resourceMap.getString(actionName + ACTION_COMMAND, new Object[0])) != null) {
                this.putValue("ActionCommandKey", command);
            }
        }
        MnemonicTextUtils.setMnemonicText(this, name);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Method actionMethod = this.getActionMethod();
        Class<?>[] parameterTypes = actionMethod.getParameterTypes();
        Object[] parameters = new Object[parameterTypes.length];
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            parameters[i2] = this.createActionParameter(parameterTypes[i2], event);
        }
        try {
            actionMethod.invoke(this.getActionTarget(), parameters);
        }
        catch (Exception e2) {
            this.throwActionError(e2, "action invocation failed");
        }
    }

    protected void throwActionError(Throwable throwable, String message) throws Error {
        LOG.log(Level.SEVERE, message, throwable);
        throw new Error(throwable);
    }

    protected Object createActionParameter(Class<?> type, ActionEvent event) {
        if (type == ActionEvent.class) {
            return event;
        }
        if (type == IAction.class || type == AbstractAction.class) {
            return this;
        }
        if (type == ResourceMap.class) {
            return this.getResourceMap();
        }
        if (type == ApplicationContext.class) {
            return this.getApplicationActionMap().getContext();
        }
        if (type == Application.class) {
            return this.getApplicationActionMap().getContext().getApplication();
        }
        this.throwActionError(new IllegalArgumentException("Unsupported parameter type " + type.toString()), "Could not create parameter");
        return null;
    }

    protected ApplicationActionMap getApplicationActionMap() {
        return this.fApplicationActionMap;
    }

    protected ResourceMap getResourceMap() {
        return this.fResourceMap;
    }

    protected String getActionName() {
        return this.fActionName;
    }

    protected Method getActionMethod() {
        return this.fActionMethod;
    }

    protected Object getActionTarget() {
        return this.fActionTarget;
    }

    protected String getEnabledProperty() {
        return this.fEnabledProperty;
    }

    private Method getEnabledPropertyReadMethod() {
        return this.fEnabledPropertyReadMethod;
    }

    private void setEnabledPropertyReadMethod(Method enablingPropertyReadMethod) {
        this.fEnabledPropertyReadMethod = enablingPropertyReadMethod;
    }

    private Method getEnabledPropertyWriteMethod() {
        return this.fEnabledPropertyWriteMethod;
    }

    private void setEnabledPropertyWriteMethod(Method enablingPropertyWriteMethod) {
        this.fEnabledPropertyWriteMethod = enablingPropertyWriteMethod;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(this.getEnabledProperty())) {
            this.firePropertyChange("enabled", evt.getOldValue(), evt.getNewValue());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeMethod(out, this.fActionMethod);
        this.writeMethod(out, this.fEnabledPropertyReadMethod);
        this.writeMethod(out, this.fEnabledPropertyWriteMethod);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.fActionMethod = this.readMethod(in);
        this.fEnabledPropertyReadMethod = this.readMethod(in);
        this.fEnabledPropertyWriteMethod = this.readMethod(in);
    }

    private void writeMethod(ObjectOutputStream out, Method aMethod) throws IOException {
        if (aMethod == null) {
            out.writeObject(null);
        } else {
            Class<?> declaringClass = aMethod.getDeclaringClass();
            out.writeObject(declaringClass);
            String name2 = aMethod.getName();
            out.writeObject(name2);
            Class<?>[] parameterTypes = aMethod.getParameterTypes();
            out.writeObject(parameterTypes);
        }
    }

    private Method readMethod(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class declaringClass = (Class)in.readObject();
        if (declaringClass == null) {
            return null;
        }
        String methodName = (String)in.readObject();
        Class[] parameterTypes = (Class[])in.readObject();
        try {
            return declaringClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e2) {
            throw new IOException(e2.getMessage());
        }
    }
}

