/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application;

import java.io.Serializable;

public class MnemonicText
implements Serializable {
    private String fText;
    private Character fMnemonicChar;
    private int fMnemonicIndex;

    public MnemonicText(String mnemonicText) {
        if (mnemonicText == null) {
            mnemonicText = "";
        }
        this.fText = mnemonicText;
        this.fMnemonicIndex = -1;
        int escapes = 0;
        for (int i2 = 0; i2 < mnemonicText.length() - 1; ++i2) {
            char currentChar = mnemonicText.charAt(i2);
            if (currentChar != '&') continue;
            if (mnemonicText.charAt(i2 + 1) == '&') {
                ++i2;
                ++escapes;
                continue;
            }
            this.fText = mnemonicText.substring(0, i2) + mnemonicText.substring(i2 + 1);
            this.fMnemonicChar = Character.valueOf(mnemonicText.substring(i2 + 1, i2 + 2).toUpperCase().charAt(0));
            this.fMnemonicIndex = i2 - escapes;
            break;
        }
        this.fText = this.fText.replace("&&", "&");
    }

    public String getText() {
        return this.fText;
    }

    public Character getMnemonicChar() {
        return this.fMnemonicChar;
    }

    public int getMnemonicCharCode() {
        return this.fMnemonicChar.charValue();
    }

    public int getMnemonicIndex() {
        return this.fMnemonicIndex;
    }

    public boolean hasMnemonic() {
        return this.fMnemonicChar != null;
    }
}

