/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application;

import com.ulcjava.applicationframework.application.AbstractResourceConverter;
import com.ulcjava.applicationframework.application.ClientContextLocaleProvider;
import com.ulcjava.applicationframework.application.ILocaleProvider;
import com.ulcjava.applicationframework.application.IResourceConverter;
import com.ulcjava.applicationframework.application.MnemonicTextUtils;
import com.ulcjava.base.application.ULCAbstractButton;
import com.ulcjava.base.application.ULCComponent;
import com.ulcjava.base.application.ULCContainer;
import com.ulcjava.base.application.ULCLabel;
import com.ulcjava.base.application.ULCMenu;
import com.ulcjava.base.application.util.Color;
import com.ulcjava.base.application.util.Font;
import com.ulcjava.base.application.util.KeyStroke;
import com.ulcjava.base.application.util.ULCIcon;
import com.ulcjava.base.shared.internal.ClassUtilities;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMap
implements Serializable {
    private static Map<ResourceMapKey, ResourceMapCacheEntry> sResourceMapCache = new HashMap<ResourceMapKey, ResourceMapCacheEntry>(25);
    public static final String EXPRESSION_NULL = "null";
    public static final String CONSTANT_BEGIN = "#{";
    public static final String EXPRESSION_BEGIN = "${";
    public static final String EXPRESSION_END = "}";
    public static final String STYLE_CLIENT_PROPERTY = "ulc.style";
    private static final Logger LOG = Logger.getLogger(ResourceMap.class.getName());
    private final ResourceMap fParent;
    private final List<String> fBundleNames;
    private Locale fLocale;
    private String fResourcesDir;
    private ResourceMapCacheEntry fCacheEntry;
    private final ILocaleProvider fLocaleProvider;

    public static void resetCache() {
        sResourceMapCache.clear();
    }

    public ResourceMap(ResourceMap parent, List<String> bundleNames) {
        this(parent, bundleNames, ClientContextLocaleProvider.getInstance());
    }

    public ResourceMap(ResourceMap parent, List<String> bundleNames, ILocaleProvider localeProvider) {
        if (bundleNames == null) {
            throw new IllegalArgumentException("bundleNames must not be null");
        }
        if (localeProvider == null) {
            throw new IllegalArgumentException("localeProvider must not be null");
        }
        for (String bundleName : bundleNames) {
            if (bundleName == null || bundleName.length() == 0) {
                throw new IllegalArgumentException("bundleName must not be null nor empty");
            }
            String baseDir = this.getBaseDir(bundleName);
            if (this.fResourcesDir == null) {
                this.fResourcesDir = baseDir;
                continue;
            }
            if (baseDir.equals(this.fResourcesDir)) continue;
            throw new IllegalArgumentException("all bundle files  must be from the the same directory (" + bundleName + " not in " + this.fResourcesDir + ")");
        }
        this.fLocaleProvider = localeProvider;
        this.fResourcesDir = this.fResourcesDir.replace('.', '/') + "/";
        this.fParent = parent;
        this.fBundleNames = Collections.unmodifiableList(new ArrayList<String>(bundleNames));
        this.fLocale = localeProvider.getLocale();
    }

    public ResourceMap(ResourceMap parent, String ... bundleNames) {
        this(parent, Arrays.asList(bundleNames));
    }

    public ResourceMap(ResourceMap parent, ILocaleProvider localeProvider, String ... bundleNames) {
        this(parent, Arrays.asList(bundleNames), localeProvider);
    }

    private String getBaseDir(String bundleName) {
        return bundleName.substring(0, bundleName.lastIndexOf(46));
    }

    public ResourceMap getParent() {
        return this.fParent;
    }

    public List<String> getBundleNames() {
        return this.fBundleNames;
    }

    public ClassLoader getClassLoader() {
        return ClassUtilities.getDefaultClassLoader();
    }

    public String getResourcesDir() {
        return this.fResourcesDir;
    }

    public boolean containsKey(String key) {
        return this.getMap().containsKey(key) || this.getParent().containsKey(key);
    }

    protected Map<String, String> getMap() {
        return this.getCacheEntry().getMap();
    }

    private ResourceMapCacheEntry getCacheEntry() {
        if (this.fCacheEntry == null || !this.fLocale.equals(this.fLocaleProvider.getLocale())) {
            this.fCacheEntry = this.loadResources();
        }
        return this.fCacheEntry;
    }

    private synchronized ResourceMapCacheEntry loadResources() {
        this.fLocale = this.fLocaleProvider.getLocale();
        ResourceMapKey mapKey = new ResourceMapKey(this.getBundleNames(), this.fLocale);
        ResourceMapCacheEntry cacheEntry = sResourceMapCache.get(mapKey);
        if (cacheEntry == null) {
            HashMap<String, String> resourceMap = new HashMap<String, String>();
            List<String> bundleNames = this.getBundleNames();
            for (int i2 = bundleNames.size() - 1; i2 >= 0; --i2) {
                String bundleName = bundleNames.get(i2);
                ResourceBundle bundle = null;
                try {
                    bundle = ResourceBundle.getBundle(bundleName, this.fLocale, this.getClassLoader());
                }
                catch (MissingResourceException e2) {
                    // empty catch block
                }
                if (bundle == null) continue;
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    resourceMap.put(key, bundle.getString(key));
                }
            }
            HashSet<String> resourceKeySet = new HashSet<String>(resourceMap.keySet());
            if (this.getParent() != null) {
                resourceKeySet.addAll(this.getParent().getResourceKeySet());
            }
            cacheEntry = new ResourceMapCacheEntry(resourceMap, resourceKeySet);
            sResourceMapCache.put(mapKey, cacheEntry);
        }
        return cacheEntry;
    }

    protected Set<String> getResourceKeySet() {
        return this.getCacheEntry().getResourceKeySet();
    }

    protected String getResource(String key) {
        String value = this.getMap().get(key);
        return value == null && this.getParent() != null ? this.getParent().getResource(key) : value;
    }

    public Object getObject(String key, Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        String resourceString = this.getResource(key);
        resourceString = this.evaluateExpression(resourceString, type, key);
        Object resource = resourceString;
        if (resourceString != null) {
            if (resourceString.startsWith(CONSTANT_BEGIN)) {
                resource = this.lookupConstant(key, type, resourceString);
                if (!type.isInstance(resource) && String.class.isAssignableFrom(type)) {
                    resource = resource.toString();
                }
            } else if (!type.isInstance(resourceString)) {
                IResourceConverter<?> converter = AbstractResourceConverter.forType(type);
                try {
                    if (converter == null) {
                        throw new LookupException("no converter defined", key, type);
                    }
                    resource = converter.parseString(resourceString, this);
                }
                catch (AbstractResourceConverter.ResourceConverterException e2) {
                    throw new LookupException(e2.getMessage(), key, type, e2);
                }
            }
        }
        return resource;
    }

    private Object lookupConstant(String key, Class<?> type, String resourceString) {
        Object resource;
        if (resourceString.endsWith(EXPRESSION_END)) {
            Class<?> clazz;
            String fullClassName;
            String constantName = resourceString.substring(2, resourceString.length() - 1);
            int dotAfterClassname = constantName.lastIndexOf(46);
            if (dotAfterClassname <= 0) {
                throw new LookupException("No Classname defined in constant expression" + resourceString + "<", key, type);
            }
            int dotBeforeClassSimpleName = (fullClassName = constantName.substring(0, dotAfterClassname)).lastIndexOf(46);
            String classSimpleName = fullClassName.substring(dotBeforeClassSimpleName < 0 ? 0 : dotBeforeClassSimpleName + 1);
            if (dotBeforeClassSimpleName < 0) {
                fullClassName = "com.ulcjava.base.application." + classSimpleName;
            }
            String fieldName = constantName.substring(dotAfterClassname + 1);
            try {
                clazz = Class.forName(fullClassName, true, this.getClassLoader());
            }
            catch (ClassNotFoundException e2) {
                throw new LookupException("Class not found in constant expression >" + resourceString + "<", key, type, e2);
            }
            catch (Exception e3) {
                throw new LookupException("Error on loading class in constant expression >" + resourceString + "<", key, type, e3);
            }
            try {
                Field constant = clazz.getField(fieldName);
                resource = constant.get(null);
            }
            catch (NoSuchFieldException e4) {
                throw new LookupException("Field not defined in constant expression >" + resourceString + "<", key, type, e4);
            }
            catch (Exception e5) {
                throw new LookupException("Field could not be read in constant expression >" + resourceString + "<", key, type, e5);
            }
        }
        throw new LookupException("Missing closing } in constant expression >" + resourceString + "<", key, type);
        return resource;
    }

    private String evaluateExpression(String resourceString, Class type, String key) {
        if (resourceString == null) {
            return resourceString;
        }
        String result = resourceString;
        int expStart = result.indexOf(EXPRESSION_BEGIN);
        while (expStart > -1) {
            if (this.isNotEscaped(result, expStart)) {
                int expEnd = result.indexOf(EXPRESSION_END, expStart + 2);
                if (expEnd < 0) {
                    throw new LookupException("Missing closing } in expression >" + resourceString + "<", key, type);
                }
                String expression = result.substring(expStart + 2, expEnd);
                if (expression.length() == 0) {
                    throw new LookupException("Empty expression in >" + resourceString + "<", key, type);
                }
                if (expression.equals(EXPRESSION_NULL)) {
                    return null;
                }
                String expressionResult = this.getString(expression, new Object[0]);
                if (expressionResult == null) {
                    throw new LookupException("Expression results in NULL >" + resourceString + "<", key, type);
                }
                result = result.substring(0, this.escapeCharOnPosition(result, expStart - 1) ? expStart - 1 : expStart) + expressionResult + result.substring(expEnd + 1);
                expStart = result.indexOf(EXPRESSION_BEGIN, expStart);
                continue;
            }
            result = result.substring(0, expStart - 1) + result.substring(expStart);
            expStart = result.indexOf(EXPRESSION_BEGIN, expStart + 1);
        }
        return result;
    }

    private boolean isNotEscaped(String result, int expStart) {
        return !this.escapeCharOnPosition(result, expStart - 1) || this.escapeCharOnPosition(result, expStart - 2);
    }

    private boolean escapeCharOnPosition(String result, int backslashPos) {
        return backslashPos >= 0 && result.charAt(backslashPos) == '\\';
    }

    public String getString(String key, Object ... args) {
        String result = (String)this.getObject(key, String.class);
        if (args != null && args.length > 0 && result != null) {
            MessageFormat messageFormat = new MessageFormat(result, this.fLocale);
            result = messageFormat.format(args);
        }
        return result;
    }

    public final Boolean getBoolean(String key) {
        return (Boolean)this.getObject(key, Boolean.class);
    }

    public final Integer getInteger(String key) {
        return (Integer)this.getObject(key, Integer.class);
    }

    public final Long getLong(String key) {
        return (Long)this.getObject(key, Long.class);
    }

    public final Short getShort(String key) {
        return (Short)this.getObject(key, Short.class);
    }

    public final Byte getByte(String key) {
        return (Byte)this.getObject(key, Byte.class);
    }

    public final Float getFloat(String key) {
        return (Float)this.getObject(key, Float.class);
    }

    public final Double getDouble(String key) {
        return (Double)this.getObject(key, Double.class);
    }

    public final ULCIcon getULCIcon(String key) {
        return (ULCIcon)this.getObject(key, ULCIcon.class);
    }

    public final Font getFont(String key) {
        return (Font)this.getObject(key, Font.class);
    }

    public final Color getColor(String key) {
        return (Color)this.getObject(key, Color.class);
    }

    public final KeyStroke getKeyStroke(String key) {
        return (KeyStroke)this.getObject(key, KeyStroke.class);
    }

    public Integer getKeyCode(String key) {
        KeyStroke keyStroke = this.getKeyStroke(key);
        return keyStroke == null ? null : Integer.valueOf(keyStroke.getKeyCode());
    }

    public void injectComponent(ULCComponent target) {
        String style;
        if (target == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        HashMap<String, String> propertyKeys = new HashMap<String, String>();
        this.fillResourceKeys(propertyKeys, target.getClass(), ULCComponent.class);
        String name = target.getName();
        String string = style = name != null && name.trim().length() > 0 ? this.getString(name + "." + "style", new Object[0]) : null;
        if (style == null) {
            Object styleProperty = target.getClientProperty(STYLE_CLIENT_PROPERTY);
            String string2 = style = styleProperty != null ? styleProperty.toString() : null;
        }
        if (style != null) {
            this.fillResourceKeys(propertyKeys, style);
        }
        if (name != null && name.trim().length() > 0) {
            this.fillResourceKeys(propertyKeys, name);
        }
        Set entrySet = propertyKeys.entrySet();
        for (Map.Entry propertyKeyEntry : entrySet) {
            Class propertyType;
            String key = (String)propertyKeyEntry.getValue();
            String propertyName = (String)propertyKeyEntry.getKey();
            try {
                propertyType = PropertyUtils.getPropertyType((Object)target, (String)propertyName);
            }
            catch (Exception e2) {
                propertyType = null;
            }
            if (propertyType == null) continue;
            Object value = this.getObject(key, propertyType);
            if (propertyName.equals("text")) {
                if (target instanceof ULCAbstractButton) {
                    MnemonicTextUtils.setMnemonicText((ULCAbstractButton)target, (String)value);
                }
                if (!(target instanceof ULCLabel)) continue;
                MnemonicTextUtils.setMnemonicText((ULCLabel)target, (String)value);
                continue;
            }
            try {
                PropertyUtils.setProperty((Object)target, (String)propertyName, (Object)value);
            }
            catch (Exception e3) {
                throw new PropertyInjectionException("Could not set property", target, key, value);
            }
        }
    }

    private <T> void fillResourceKeys(Map<String, String> propertyKeys, Class<? extends T> startClass, Class<T> endClass) {
        ArrayList<String> classes = new ArrayList<String>();
        for (Class<T> clazz = startClass; clazz != endClass.getSuperclass(); clazz = clazz.getSuperclass()) {
            classes.add(clazz.getSimpleName());
        }
        for (int i2 = classes.size() - 1; i2 >= 0; --i2) {
            this.fillResourceKeys(propertyKeys, (String)classes.get(i2));
        }
    }

    private void fillResourceKeys(Map<String, String> propertyKeys, String prefix) {
        prefix = prefix + ".";
        List<String> resourceKeys = this.resourceKeysFor(prefix);
        for (String key : resourceKeys) {
            if (key.length() == prefix.length()) {
                LOG.log(Level.WARNING, "Missing property name for key " + key);
            }
            String propertyName = key.substring(prefix.length());
            propertyKeys.put(propertyName, key);
        }
    }

    public List<String> getResourceKeys(String prefix) {
        if (prefix == null || prefix.trim().length() == 0) {
            throw new IllegalArgumentException("prefix must not be null nor empty");
        }
        return this.resourceKeysFor(prefix);
    }

    private List<String> resourceKeysFor(String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        Set<String> keys = this.getResourceKeySet();
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            result.add(key);
        }
        return result;
    }

    public void injectComponents(ULCComponent root) {
        this.injectComponent(root);
        ULCComponent[] components = new ULCComponent[]{};
        if (root instanceof ULCMenu) {
            components = ((ULCMenu)root).getMenuComponents();
        }
        if (root instanceof ULCContainer) {
            components = ((ULCContainer)root).getComponents();
        }
        for (ULCComponent component : components) {
            this.injectComponents(component);
        }
    }

    public static class PropertyInjectionException
    extends RuntimeException {
        public PropertyInjectionException(String msg, ULCComponent component, String key, Object value) {
            super(msg + " key:" + key + " value:" + value + " component:" + component);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LookupException
    extends RuntimeException {
        public LookupException(String msg, String key, Class<?> type) {
            this(msg, key, type, null);
        }

        public LookupException(String msg, String key, Class<?> type, Exception e2) {
            super(msg + ": key " + key + " type " + type, e2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceMapCacheEntry
    implements Serializable {
        private final Map<String, String> fMap;
        private final Set<String> fResourceKeySet;

        public ResourceMapCacheEntry(Map<String, String> map, Set<String> resourceKeySet) {
            this.fMap = map;
            this.fResourceKeySet = resourceKeySet;
        }

        public Map<String, String> getMap() {
            return this.fMap;
        }

        public Set<String> getResourceKeySet() {
            return this.fResourceKeySet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceMapKey
    implements Serializable {
        private final Locale fKeyLocale;
        private final String[] fBundleNames;

        public ResourceMapKey(List<String> bundleNames, Locale locale) {
            if (locale == null) {
                throw new IllegalArgumentException("locale must not be null");
            }
            if (bundleNames == null) {
                throw new IllegalArgumentException("bundleNames must not be null");
            }
            this.fKeyLocale = locale;
            this.fBundleNames = bundleNames.toArray(new String[bundleNames.size()]);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.fBundleNames);
            result = 31 * result + this.fKeyLocale.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceMapKey other = (ResourceMapKey)obj;
            if (!Arrays.equals(this.fBundleNames, other.fBundleNames)) {
                return false;
            }
            return this.fKeyLocale.equals(other.fKeyLocale);
        }
    }
}

