/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application;

import com.ulcjava.applicationframework.application.AppletView;
import com.ulcjava.applicationframework.application.Application;
import com.ulcjava.applicationframework.application.FrameView;
import com.ulcjava.applicationframework.application.MnemonicTextUtils;
import com.ulcjava.applicationframework.application.ToolBarFactory;
import com.ulcjava.applicationframework.application.View;
import com.ulcjava.base.application.ClientContext;
import com.ulcjava.base.application.IAction;
import com.ulcjava.base.application.ULCButton;
import com.ulcjava.base.application.ULCComponent;
import com.ulcjava.base.application.ULCFrame;
import com.ulcjava.base.application.ULCMenu;
import com.ulcjava.base.application.ULCMenuBar;
import com.ulcjava.base.application.ULCMenuItem;
import com.ulcjava.base.application.ULCRootPane;
import com.ulcjava.base.application.ULCToolBar;
import com.ulcjava.base.application.event.IWindowListener;
import com.ulcjava.base.application.event.WindowEvent;
import com.ulcjava.environment.applet.application.ULCAppletPane;
import java.io.Serializable;

public abstract class SingleFrameApplication
extends Application {
    private View fMainView;
    private ToolBarFactory fToolBarFactory;

    protected void startup() {
        this.setMenuBar(this.createStartupMenuBar());
        this.setToolBar(this.createStartupToolBar());
        this.setStatusBar(this.createStartupStatusBar());
        this.setMainContent(this.createStartupMainContent());
        this.show(this.getMainView());
    }

    protected ULCComponent createStartupMainContent() {
        return null;
    }

    protected ULCComponent createStartupStatusBar() {
        return null;
    }

    protected ULCComponent createStartupToolBar() {
        return null;
    }

    protected ULCMenuBar createStartupMenuBar() {
        return null;
    }

    public ULCComponent getMainContent() {
        return this.getMainView().getMainContent();
    }

    public ULCComponent getStatusBar() {
        return this.getMainView().getStatusBar();
    }

    public ULCMenuBar getMenuBar() {
        return this.getMainView().getMenuBar();
    }

    public ULCComponent getToolBar() {
        return this.getMainView().getToolBar();
    }

    public void setMainContent(ULCComponent component) {
        this.getMainView().setMainContent(component);
    }

    public void setStatusBar(ULCComponent statusBar) {
        this.getMainView().setStatusBar(statusBar);
    }

    public void setMenuBar(ULCMenuBar menuBar) {
        this.getMainView().setMenuBar(menuBar);
    }

    public void setToolBar(ULCComponent createStartupToolBar) {
        this.getMainView().setToolBar(createStartupToolBar);
    }

    protected void show(ULCComponent mainContent) {
        if (mainContent == null) {
            throw new IllegalArgumentException("component must not be null");
        }
        View mainView = this.getMainView();
        mainView.setMainContent(mainContent);
        this.show(mainView);
    }

    public View getMainView() {
        if (this.fMainView == null) {
            this.fMainView = this.createMainView();
        }
        return this.fMainView;
    }

    protected View createMainView() {
        if (ClientContext.getClientEnvironmentType() != 1) {
            FrameView frameView = this.createFrameView();
            this.initFrame(frameView.getFrame());
            return frameView;
        }
        AppletView appletView = this.createAppletView();
        this.initAppletView(appletView);
        return appletView;
    }

    public ULCRootPane getRootPane() {
        return this.getMainView().getRootPane();
    }

    public ULCFrame getFrame() {
        if (this.getRootPane() instanceof ULCFrame) {
            return (ULCFrame)this.getRootPane();
        }
        return null;
    }

    public ULCAppletPane getAppletPane() {
        if (this.getRootPane() instanceof ULCAppletPane) {
            return (ULCAppletPane)this.getRootPane();
        }
        return null;
    }

    protected AppletView createAppletView() {
        return new AppletView(this);
    }

    protected FrameView createFrameView() {
        return new FrameView(this);
    }

    protected void initAppletView(AppletView appletView) {
        this.initAppletPane(appletView.getAppletPane());
    }

    protected void initAppletPane(ULCAppletPane appletPane) {
    }

    protected void initFrame(ULCFrame frame) {
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new IWindowListener(){

            public void windowClosing(WindowEvent event) {
                SingleFrameApplication.this.exit(event);
            }
        });
    }

    protected ToolBarFactory getToolBarFactory() {
        if (this.fToolBarFactory == null) {
            this.fToolBarFactory = this.createToolbarFactory();
        }
        return this.fToolBarFactory;
    }

    protected ToolBarFactory createToolbarFactory() {
        return this.createToolBarFactory();
    }

    public ToolBarFactory createToolBarFactory() {
        return new ToolBarFactory(this.getContext().getActionMap());
    }

    public void createAndAddToolBar(String ... actions) {
        ULCToolBar toolBar = this.buildToolBar(actions);
        this.getMainView().setToolBar(toolBar);
    }

    public ULCToolBar createToolbar(String ... actions) {
        return this.buildToolBar(actions);
    }

    public ULCToolBar buildToolBar(String ... actions) {
        return this.getToolBarFactory().createToolBar(actions);
    }

    public ULCButton createToolbarButton(String actionName) {
        return this.createToolBarButton(actionName);
    }

    public ULCButton createToolBarButton(String actionName) {
        return this.getToolBarFactory().createToolBarButton(actionName);
    }

    protected IAction getAction(String actionName) {
        return this.getContext().getActionMap().get(actionName);
    }

    public void createMenuBar(String[] ... menus) {
        if (menus == null) {
            throw new IllegalArgumentException("menues must not be null");
        }
        if (menus.length == 0) {
            throw new IllegalArgumentException("there must be at least one menu");
        }
        MenuBuilder[] builders = new MenuBuilder[menus.length];
        for (int i2 = 0; i2 < menus.length; ++i2) {
            String[] items = menus[i2];
            if (items == null) {
                throw new IllegalArgumentException("a single menu must not be null");
            }
            if (items.length < 2) {
                throw new IllegalArgumentException("a single menu must have a at least two elements (title and one entry");
            }
            String[] entries = new String[items.length - 1];
            System.arraycopy(items, 1, entries, 0, entries.length);
            builders[i2] = new MenuBuilder(items[0], entries);
        }
        this.createMenuBar(builders);
    }

    public void createMenuBar(MenuBuilder ... menus) {
        if (menus == null) {
            throw new IllegalArgumentException("menues must not be null");
        }
        if (menus.length == 0) {
            throw new IllegalArgumentException("there must be at least one menu");
        }
        for (MenuBuilder menu : menus) {
            this.addMenu(menu);
        }
    }

    public ULCMenuBar buildMenuBar(String[] ... menus) {
        if (menus == null) {
            throw new IllegalArgumentException("menues must not be null");
        }
        if (menus.length == 0) {
            throw new IllegalArgumentException("there must be at least one menu");
        }
        MenuBuilder[] builders = new MenuBuilder[menus.length];
        for (int i2 = 0; i2 < menus.length; ++i2) {
            String[] items = menus[i2];
            if (items == null) {
                throw new IllegalArgumentException("a single menu must not be null");
            }
            if (items.length < 2) {
                throw new IllegalArgumentException("a single menu must have a at least two elements (title and one entry");
            }
            String[] entries = new String[items.length - 1];
            System.arraycopy(items, 1, entries, 0, entries.length);
            builders[i2] = new MenuBuilder(items[0], entries);
        }
        return this.buildMenuBar(builders);
    }

    public ULCMenuBar buildMenuBar(MenuBuilder ... menus) {
        ULCMenuBar menuBar = new ULCMenuBar();
        if (menus == null) {
            throw new IllegalArgumentException("menues must not be null");
        }
        if (menus.length == 0) {
            throw new IllegalArgumentException("there must be at least one menu");
        }
        for (MenuBuilder menuBuilder : menus) {
            menuBar.add(menuBuilder.getMenu());
        }
        return menuBar;
    }

    public void addMenu(MenuBuilder menuBuilder) {
        if (menuBuilder == null) {
            throw new IllegalArgumentException("menues must not contain null");
        }
        ULCMenuBar menuBar = this.getMainView().getMenuBar();
        menuBar.add(menuBuilder.getMenu());
    }

    public class MenuBuilder
    implements Serializable {
        private final String[] fActions;
        private final String fTitle;

        public MenuBuilder(String title, String ... items) {
            if (title == null) {
                throw new IllegalArgumentException("title must not be null");
            }
            if (items == null) {
                throw new IllegalArgumentException("actions must not be null");
            }
            if (items.length == 0) {
                throw new IllegalArgumentException("actions must not be empty");
            }
            for (String action : items) {
                if (action != null) continue;
                throw new IllegalArgumentException("action must not be null");
            }
            this.fTitle = title;
            this.fActions = items;
        }

        public ULCMenu getMenu() {
            String text = this.fromResourceOrKeep(this.fTitle);
            ULCMenu menu = new ULCMenu();
            MnemonicTextUtils.setMnemonicText(menu, this.fromResourceOrKeep(text));
            for (String item : this.fActions) {
                if (item.matches("-+")) {
                    menu.addSeparator();
                    continue;
                }
                IAction action = SingleFrameApplication.this.getAction(item);
                if (action == null) {
                    ULCMenuItem menuItem = new ULCMenuItem();
                    MnemonicTextUtils.setMnemonicText(menuItem, this.fromResourceOrKeep(item));
                    menu.add(menuItem);
                    continue;
                }
                menu.add(new ULCMenuItem(action));
            }
            return menu;
        }

        private String fromResourceOrKeep(String key) {
            String text = SingleFrameApplication.this.getContext().getResourceMap().getString(key, new Object[0]);
            if (text == null) {
                text = key;
            }
            return text;
        }
    }
}

