/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application;

import com.ulcjava.applicationframework.application.Application;
import com.ulcjava.applicationframework.application.ApplicationContext;
import com.ulcjava.applicationframework.application.ResourceMap;
import com.ulcjava.base.application.ULCComponent;
import com.ulcjava.base.application.ULCContainer;
import com.ulcjava.base.application.ULCMenuBar;
import com.ulcjava.base.application.ULCRootPane;
import java.io.Serializable;

public abstract class View
implements Serializable {
    private final Application fApplication;
    private ULCComponent fMainContent;
    private ULCComponent fStatusBar;
    private ULCMenuBar fMenuBar;
    private ULCComponent fToolBar;

    public View(Application application) {
        if (application == null) {
            throw new IllegalArgumentException("application must not be null");
        }
        this.fApplication = application;
    }

    public final Application getApplication() {
        return this.fApplication;
    }

    public final ApplicationContext getContext() {
        return this.getApplication().getContext();
    }

    public abstract ULCRootPane getRootPane();

    public ULCComponent getComponent() {
        return this.getMainContent();
    }

    public ULCComponent getMainContent() {
        return this.fMainContent;
    }

    public void setComponent(ULCComponent component) {
        this.setMainContent(component);
    }

    public void setMainContent(ULCComponent mainContent) {
        this.putIntoContentPane(mainContent, this.fMainContent, "Center");
        this.fMainContent = mainContent;
    }

    private void putIntoContentPane(ULCComponent component, ULCComponent oldComponent, String borderLayoutPaneConstraints) {
        ULCContainer contentPane = this.getRootPane().getContentPane();
        if (oldComponent != null) {
            contentPane.remove(oldComponent);
        }
        if (component != null) {
            contentPane.add(component, borderLayoutPaneConstraints);
        }
    }

    public ULCComponent getStatusBar() {
        return this.fStatusBar;
    }

    public void setStatusBar(ULCComponent statusBar) {
        this.putIntoContentPane(statusBar, this.fStatusBar, "South");
        this.fStatusBar = statusBar;
    }

    public ULCMenuBar getMenuBar() {
        if (this.fMenuBar == null) {
            this.setMenuBar(new ULCMenuBar());
        }
        return this.fMenuBar;
    }

    public void setMenuBar(ULCMenuBar menuBar) {
        this.getRootPane().setMenuBar(menuBar);
        this.fMenuBar = menuBar;
    }

    public ULCComponent getToolBar() {
        return this.fToolBar;
    }

    public void setToolBar(ULCComponent toolBar) {
        this.putIntoContentPane(toolBar, this.fToolBar, "North");
        this.fToolBar = toolBar;
    }

    public void show() {
        this.getResourceMap().injectComponents(this.getRootPane());
        this.prepareShow();
        this.getRootPane().setVisible(true);
    }

    public ResourceMap getResourceMap() {
        return this.getContext().getResourceMap(this.getClass(), View.class);
    }

    protected void prepareShow() {
    }

    public void hide() {
        this.getRootPane().setVisible(false);
    }
}

