/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.easydeployment.server;

import com.ulcjava.base.server.ApplicationConfiguration;
import com.ulcjava.base.server.SessionLogConfigProvider;
import com.ulcjava.base.shared.logging.Level;
import com.ulcjava.base.shared.logging.Logger;
import com.ulcjava.easydeployment.server.EasyDeploymentUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import sun.security.tools.JarSigner;

public class ClientJarPreparationListener
implements ServletContextListener {
    private static final Logger LOG = Logger.getLogger(ClientJarPreparationListener.class.getName());

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        try {
            new ClientJarPreparation(servletContext).prepareClientJars();
        }
        catch (Exception e2) {
            LOG.log(Level.SEVERE, "Could not prepare client jar files", e2);
        }
    }

    static {
        SessionLogConfigProvider.initializeLogManager();
    }

    private static class ClientJarPreparation {
        private static final String SIGNJAR_PROPERTIES = "/WEB-INF/signjar.properties";
        private Properties fJarSigningProperties;
        private JarSigner fJarSigner;
        private final ServletContext fServletContext;

        public ClientJarPreparation(ServletContext servletContext) {
            this.fServletContext = servletContext;
        }

        public ServletContext getServletContext() {
            return this.fServletContext;
        }

        public void prepareClientJars() throws ServletException, IOException {
            String jnlpLauncherClassName = ApplicationConfiguration.getInstance().getJnlpLauncherClassName();
            String jnlpLauncherClassFileName = "com/ulcjava/environment/jnlp/client/DefaultJnlpLauncher.class";
            if (jnlpLauncherClassName != null) {
                jnlpLauncherClassFileName = jnlpLauncherClassName.replace('.', '/') + ".class";
            }
            boolean launcherLibFound = false;
            this.fJarSigningProperties = this.getJarSigningProperties();
            this.fJarSigner = new JarSigner();
            ServletContext servletContext = this.getServletContext();
            String jarList = EasyDeploymentUtilities.toAppletArchiveAttribute(servletContext);
            LOG.log(Level.INFO, "client libs -> " + jarList);
            if (this.getKeystoreName() == null) {
                LOG.log(Level.INFO, "No keystore defined - the jar files wont be signed");
            }
            String[] jars = jarList.split(",");
            for (int i2 = 0; i2 < jars.length; ++i2) {
                String jar = jars[i2];
                String sourceJarFileName = this.getServletContext().getRealPath("/WEB-INF/lib/" + jar);
                String destJarFileName = this.getServletContext().getRealPath("/" + jar);
                this.copyFile(sourceJarFileName, destJarFileName);
                if (launcherLibFound || !this.jarContainsJnlpLauncher(sourceJarFileName, jnlpLauncherClassFileName)) continue;
                launcherLibFound = true;
                EasyDeploymentUtilities.setJNLPLauncherLibName(jar);
            }
        }

        private boolean jarContainsJnlpLauncher(String sourceJarFileName, String jnlpLauncherClassFileName) throws IOException {
            JarFile jar = new JarFile(sourceJarFileName);
            return jar.getEntry(jnlpLauncherClassFileName) != null;
        }

        private Properties getJarSigningProperties() {
            Properties properties = new Properties();
            try {
                String propFilePath = this.getServletContext().getRealPath(SIGNJAR_PROPERTIES);
                properties.load(new FileInputStream(propFilePath));
            }
            catch (IOException e2) {
                LOG.log(Level.WARNING, "Could not read jarsigning.properties", e2);
            }
            return properties;
        }

        private void copyFile(String sourceJarFileName, String destJarFileName) {
            File source = new File(sourceJarFileName);
            File destination = new File(destJarFileName);
            if (!destination.exists() || source.lastModified() > destination.lastModified()) {
                this.doPack(sourceJarFileName, destJarFileName);
            }
        }

        private void doPack(String sourceJarFileName, String destJarFileName) {
            try {
                String packedJarFileName = destJarFileName + ".pack.gz";
                LOG.log(Level.INFO, "packing file " + sourceJarFileName + " to " + destJarFileName);
                JarFile jar = new JarFile(sourceJarFileName);
                if (this.containsNoFiles(jar)) {
                    return;
                }
                Pack200.Packer packer = Pack200.newPacker();
                FileOutputStream fileOutputStream = new FileOutputStream(packedJarFileName);
                packer.pack(jar, (OutputStream)fileOutputStream);
                fileOutputStream.close();
                Pack200.Unpacker unpacker = Pack200.newUnpacker();
                File repackedJar = new File(destJarFileName);
                FileOutputStream out = new FileOutputStream(repackedJar);
                File firstPackedFile = new File(packedJarFileName);
                JarOutputStream jarOut = new JarOutputStream(out);
                unpacker.unpack(firstPackedFile, jarOut);
                jarOut.close();
                this.sign(destJarFileName);
                GZIPOutputStream gzout = new GZIPOutputStream(new FileOutputStream(packedJarFileName));
                packer.pack(new JarFile(destJarFileName), (OutputStream)gzout);
                gzout.close();
            }
            catch (Exception e2) {
                LOG.log(Level.WARNING, "Packing of " + sourceJarFileName + " failed", e2);
            }
        }

        private boolean containsNoFiles(JarFile jarFile) {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                if (entries.nextElement().isDirectory()) continue;
                return false;
            }
            return true;
        }

        private void sign(String unpackedJarFileName) {
            String keystoreName = this.getKeystoreName();
            if (keystoreName != null) {
                try {
                    LOG.log(Level.INFO, "signing " + unpackedJarFileName);
                    this.fJarSigner.run(new String[]{"-keystore", keystoreName, "-storepass", this.getStorePass(), "-keypass", this.getKeyPass(), unpackedJarFileName, this.fJarSigningProperties.getProperty("signjar.alias")});
                }
                catch (Exception e2) {
                    LOG.log(Level.WARNING, "Signing of " + unpackedJarFileName + " failed", e2);
                }
            } else {
                LOG.log(Level.WARNING, "signjar.keystore not defined - jar files wont be signed");
            }
        }

        private String getStorePass() {
            return this.fJarSigningProperties.getProperty("signjar.storepass");
        }

        private String getKeyPass() {
            String keypass = this.fJarSigningProperties.getProperty("signjar.keypass");
            return keypass == null ? this.getStorePass() : keypass;
        }

        private String getKeystoreName() {
            String keystorename = this.fJarSigningProperties.getProperty("signjar.keystore");
            return keystorename != null ? this.getServletContext().getRealPath("/WEB-INF/" + keystorename) : null;
        }
    }
}

