/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.base.trusted;

import com.ulcjava.base.client.IBrowserService;
import com.ulcjava.base.shared.logging.Level;
import com.ulcjava.base.shared.logging.Logger;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class AllPermissionsBrowserService
implements IBrowserService {
    protected String fBrowserPath = null;
    private static String sBrowserPathProperty = "netscape";
    private static final Logger LOG = Logger.getLogger("com.ulcjava.environment.standalone.client");

    public AllPermissionsBrowserService() {
    }

    public AllPermissionsBrowserService(String browserPath) {
        this.fBrowserPath = browserPath;
    }

    public static void setBrowserPathProperty(String browserPathProperty) {
        sBrowserPathProperty = browserPathProperty;
    }

    public static String getBrowserPathProperty() {
        return sBrowserPathProperty;
    }

    public String getOSSpecificBrowserCommand(String urlString) {
        if (this.fBrowserPath == null) {
            this.setBrowserPath();
        }
        String cmds = null;
        cmds = this.fBrowserPath.endsWith(" ") ? this.fBrowserPath : this.fBrowserPath + " ";
        cmds = cmds + this.getOSSpecificUrlString(urlString);
        return cmds;
    }

    private String getOSSpecificUrlString(String urlString) {
        String os = System.getProperty("os.name").toUpperCase();
        if (os.startsWith("WINDOWS")) {
            urlString = '\"' + urlString + '\"';
        }
        return urlString;
    }

    private void setBrowserPath() {
        String os = System.getProperty("os.name").toUpperCase();
        byte v = System.getProperty("os.version").getBytes()[0];
        if (os.startsWith("WINDOWS")) {
            if (v >= 53 || os.endsWith("NT")) {
                this.fBrowserPath = "cmd /c start \"\"";
                return;
            }
            this.fBrowserPath = "start";
            return;
        }
        if (os.startsWith("MAC")) {
            this.fBrowserPath = "open";
            return;
        }
        if (os.endsWith("OS2")) {
            this.fBrowserPath = "start";
            return;
        }
        this.fBrowserPath = AllPermissionsBrowserService.getBrowserPathProperty();
    }

    public void showDocument(String urlString) {
        final String cmd = this.getOSSpecificBrowserCommand(urlString);
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LOG.log(Level.FINEST, "Executing show document command: >" + cmd + "<");
                        Runtime.getRuntime().exec(cmd);
                    }
                    catch (IOException e) {
                        LOG.log(Level.WARNING, "Exception executing: >" + cmd + "<", e);
                    }
                    return null;
                }
            });
        }
        catch (SecurityException e) {
            LOG.log(Level.WARNING, "Exception executing: >" + cmd + "<", e);
        }
    }

    public void showDocument(String urlString, String target) {
        this.showDocument(urlString);
    }
}

