/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application;

import com.ulcjava.applicationframework.application.Action;
import com.ulcjava.applicationframework.application.ApplicationAction;
import com.ulcjava.applicationframework.application.ApplicationContext;
import com.ulcjava.applicationframework.application.ResourceMap;
import com.ulcjava.base.application.IAction;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationActionMap
implements Serializable {
    private final ApplicationContext fContext;
    private final Class<?> fActionsClass;
    private final Object fActionsObject;
    private final ResourceMap fResourceMap;
    private final Map<String, ApplicationAction> fMap;
    private ApplicationActionMap fParentMap;

    public ApplicationActionMap(ApplicationContext context, Class<?> actionsClass, Object actionsObject, ResourceMap resourceMap) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (actionsClass == null) {
            throw new IllegalArgumentException("actionsClass must not be null");
        }
        if (actionsObject == null) {
            throw new IllegalArgumentException("actionsObject must not be null");
        }
        if (!actionsClass.isInstance(actionsObject)) {
            throw new IllegalArgumentException("actionsObject must be of type " + actionsClass.toString());
        }
        this.fContext = context;
        this.fActionsClass = actionsClass;
        this.fActionsObject = actionsObject;
        this.fResourceMap = resourceMap;
        this.fMap = new HashMap<String, ApplicationAction>();
        this.createActionsFromAnnotation(actionsClass);
    }

    private void createActionsFromAnnotation(Class<?> actionsClass) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = actionsClass.getDeclaredMethods()) {
            Action action = method.getAnnotation(Action.class);
            if (action == null) continue;
            String actionName = this.isDefined(action.name()) ? action.name() : method.getName();
            String enabledProperty = this.isDefined(action.enabledProperty()) ? action.enabledProperty() : null;
            ApplicationAction applicationAction = new ApplicationAction(this, this.getResourceMap(), actionName, method, enabledProperty);
            this.fMap.put(actionName, applicationAction);
        }
    }

    private boolean isDefined(String name) {
        return name != null && name.length() > 0;
    }

    protected ApplicationContext getContext() {
        return this.fContext;
    }

    protected Class<?> getActionsClass() {
        return this.fActionsClass;
    }

    protected Object getActionsObject() {
        return this.fActionsObject;
    }

    protected ResourceMap getResourceMap() {
        return this.fResourceMap;
    }

    public IAction get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        IAction action = this.fMap.get(key);
        return action == null && this.getParentMap() != null ? this.getParentMap().get(key) : action;
    }

    public Set<String> allKeys() {
        HashSet<String> allKeys = new HashSet<String>(this.fMap.keySet());
        if (this.getParentMap() != null) {
            allKeys.addAll(this.getParentMap().allKeys());
        }
        return allKeys;
    }

    protected ApplicationActionMap getParentMap() {
        return this.fParentMap;
    }

    protected void setParentMap(ApplicationActionMap parentMap) {
        this.fParentMap = parentMap;
    }
}

