/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application;

import com.ulcjava.applicationframework.application.ApplicationActionMap;
import com.ulcjava.base.application.IAction;
import com.ulcjava.base.application.ULCButton;
import com.ulcjava.base.application.ULCToolBar;
import com.ulcjava.base.application.util.Insets;
import java.io.Serializable;

public class ToolBarFactory
implements Serializable {
    private final ApplicationActionMap fActionMap;

    public ToolBarFactory(ApplicationActionMap actionMap) {
        this.fActionMap = actionMap;
    }

    public ULCToolBar createToolBar(String ... actions) {
        if (actions == null) {
            throw new IllegalArgumentException("actions must not be null");
        }
        if (actions.length == 0) {
            throw new IllegalArgumentException("there must be at least one actions");
        }
        ULCToolBar toolBar = this.createToolBar();
        for (String action : actions) {
            if (action == null) {
                throw new IllegalArgumentException("a single menu must not be null");
            }
            toolBar.add(this.createToolBarButton(action));
        }
        return toolBar;
    }

    protected ULCToolBar createToolBar() {
        ULCToolBar toolBar = new ULCToolBar(0);
        toolBar.setFloatable(false);
        return toolBar;
    }

    protected ULCButton createToolBarButton(String actionName) {
        ULCButton button = new ULCButton();
        IAction action = this.fActionMap.get(actionName);
        button.setAction(action);
        button.setName(actionName + ".ToolBarButton");
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setFocusable(false);
        button.setMargin(new Insets(0, 15, 0, 15));
        button.setBorderPainted(false);
        return button;
    }
}

