/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application.binding.table;

import com.ulcjava.applicationframework.application.binding.table.ObservableList;
import com.ulcjava.applicationframework.application.binding.table.ObservableListListener;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObservableCollections {
    public static <T> ObservableList<T> createObservableList(List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        return new ObservableListImpl<T>(list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObservableListImpl<T>
    extends AbstractList<T>
    implements ObservableList<T>,
    Serializable {
        private List<T> fList;
        private List<ObservableListListener<T>> fListeners;

        ObservableListImpl(List<T> list) {
            this.fList = list;
            this.fListeners = new CopyOnWriteArrayList<ObservableListListener<T>>();
        }

        @Override
        public void addObservableListListener(ObservableListListener<T> listener) {
            this.fListeners.add(listener);
        }

        @Override
        public void removeObservableListListener(ObservableListListener<T> listener) {
            this.fListeners.remove(listener);
        }

        @Override
        public T get(int index) {
            return this.fList.get(index);
        }

        @Override
        public int size() {
            return this.fList.size();
        }

        @Override
        public void add(int index, T element) {
            this.fList.add(index, element);
            ++this.modCount;
            for (ObservableListListener<T> listener : this.fListeners) {
                listener.listElementsAdded(this, index, 1);
            }
        }

        @Override
        public boolean addAll(Collection<? extends T> collection) {
            return this.addAll(this.size(), collection);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> collection) {
            boolean result = this.fList.addAll(index, collection);
            if (result) {
                ++this.modCount;
                for (ObservableListListener<T> listener : this.fListeners) {
                    listener.listElementsAdded(this, index, collection.size());
                }
            }
            return result;
        }

        @Override
        public void clear() {
            if (this.fList.size() == 0) {
                return;
            }
            ArrayList<T> oldElements = new ArrayList<T>(this.fList);
            this.fList.clear();
            ++this.modCount;
            for (ObservableListListener<T> listener : this.fListeners) {
                listener.listElementsRemoved(this, 0, oldElements);
            }
        }

        @Override
        public int indexOf(Object o2) {
            return this.fList.indexOf(o2);
        }

        @Override
        public int lastIndexOf(Object o2) {
            return this.fList.lastIndexOf(o2);
        }

        @Override
        public T remove(int index) {
            T result = this.fList.remove(index);
            ++this.modCount;
            for (ObservableListListener<T> listener : this.fListeners) {
                listener.listElementsRemoved(this, index, Collections.singletonList(result));
            }
            return result;
        }

        @Override
        public boolean remove(Object o2) {
            int indexOfElement = this.fList.indexOf(o2);
            boolean result = this.fList.remove(o2);
            if (result) {
                ++this.modCount;
                for (ObservableListListener<Object> observableListListener : this.fListeners) {
                    Object element = o2;
                    observableListListener.listElementsRemoved(this, indexOfElement, Collections.singletonList(element));
                }
            }
            return result;
        }

        @Override
        public T set(int index, T element) {
            T oldValue = this.fList.set(index, element);
            for (ObservableListListener<T> listener : this.fListeners) {
                listener.listElementReplaced(this, index, oldValue);
            }
            return oldValue;
        }

        @Override
        public boolean contains(Object o2) {
            return this.fList.contains(o2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.fList.containsAll(c2);
        }

        @Override
        public Object[] toArray() {
            return this.fList.toArray();
        }

        @Override
        public <E> E[] toArray(E[] a2) {
            return this.fList.toArray(a2);
        }
    }
}

