/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application.binding.table;

import com.ulcjava.applicationframework.application.binding.BindingUtils;
import com.ulcjava.applicationframework.application.binding.table.ObservableCollections;
import com.ulcjava.applicationframework.application.binding.table.ObservableList;
import com.ulcjava.applicationframework.application.binding.table.ObservableListListener;
import com.ulcjava.applicationframework.application.form.model.PropertyAccessException;
import com.ulcjava.base.application.ULCTable;
import com.ulcjava.base.application.table.AbstractTableModel;
import com.ulcjava.base.application.table.ITableCellEditor;
import com.ulcjava.base.application.table.ITableCellRenderer;
import com.ulcjava.base.application.table.ITableModel;
import com.ulcjava.base.application.table.ULCTableColumn;
import com.ulcjava.base.application.table.ULCTableColumnModel;
import com.ulcjava.base.server.streamcoder.DefaultServerCoderRegistryProvider;
import com.ulcjava.base.shared.CoderRegistry;
import com.ulcjava.base.shared.IStreamCoder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableBinding<T>
implements Serializable {
    private final ULCTable fTable;
    private final ObservableList<T> fBeanList;
    private final Class<T> fBeanClass;
    private boolean fSetAutoCreatColumnFromBean;
    private final BeanTableModel fBeanTableModel;
    private final List<ColumnBinding> fColumnBindings;

    public static <T> TableBinding<T> createTableBindingFromBeanList(List<T> beans, ULCTable table, Class<T> typeOfBean, boolean setAutoCreatColumnFromBean) {
        return new TableBinding<T>(beans, table, typeOfBean, setAutoCreatColumnFromBean);
    }

    public static <T> TableBinding<T> createTableBindingFromBeanList(List<T> beans, ULCTable table, Class<T> typeOfBean) {
        return new TableBinding<T>(beans, table, typeOfBean, false);
    }

    private TableBinding(List<T> beanList, ULCTable table, Class<T> beanClass, boolean setAutoCreatColumnFromBean) {
        if (beanList == null) {
            throw new IllegalArgumentException("The list of elements provided in the constructor can't be null");
        }
        if (table == null) {
            throw new IllegalArgumentException("The table provided in the constructor can't be null");
        }
        this.fTable = table;
        this.fBeanClass = beanClass;
        this.fSetAutoCreatColumnFromBean = setAutoCreatColumnFromBean;
        this.fBeanList = beanList instanceof ObservableList ? (ObservableList)beanList : ObservableCollections.createObservableList(beanList);
        this.fBeanList.addObservableListListener(new BeanListHandler());
        this.fBeanTableModel = new BeanTableModel();
        this.fColumnBindings = new ArrayList<ColumnBinding>();
        this.prepareTableModel();
    }

    private void prepareTableModel() {
        this.fTable.setAutoCreateColumnsFromModel(false);
        this.deleteAllColumnsOnColumnModel();
        this.fTable.setModel(this.fBeanTableModel);
        if (this.fSetAutoCreatColumnFromBean) {
            this.createDefaultColumnsFromBean();
        }
    }

    private void deleteAllColumnsOnColumnModel() {
        ULCTableColumnModel columnModel = this.fTable.getColumnModel();
        while (columnModel.getColumnCount() > 0) {
            columnModel.removeColumn(columnModel.getColumn(0));
        }
    }

    public void bind() {
        this.fBeanTableModel.fireTableStructureChanged();
    }

    private void createDefaultColumnsFromBean() {
        PropertyDescriptor[] propertyDescriptors;
        this.deleteAllColumnsOnColumnModel();
        this.fColumnBindings.clear();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = BindingUtils.getSimpleReadablePropertyDescriptors(this.fBeanClass)) {
            String columnName = propertyDescriptor.getName();
            this.addColumnBinding(columnName, columnName);
        }
        this.bind();
    }

    public ColumnBinding addColumnBinding(String propertyName) {
        return this.addColumnBinding(propertyName, propertyName);
    }

    public ColumnBinding addColumnBinding(String propertyName, String columnName) {
        int index = this.fColumnBindings.size();
        ULCTableColumn tableColumn = new ULCTableColumn(index);
        ColumnBinding columnBinding = new ColumnBinding(propertyName, columnName, tableColumn);
        this.fColumnBindings.add(columnBinding);
        this.fTable.addColumn(tableColumn);
        this.addPropertyChangeListenerToAllBeans(propertyName);
        return columnBinding;
    }

    private void addPropertyChangeListenerToAllProperties(T bean) {
        PropertyDescriptor[] beanProperties;
        for (PropertyDescriptor propertyDescriptor : beanProperties = BindingUtils.getSimpleReadablePropertyDescriptors(this.fBeanClass)) {
            this.addPropertyChangeListenerToBean(propertyDescriptor.getName(), bean);
        }
    }

    private void addPropertyChangeListenerToAllBeans(String propertyName) {
        for (Object bean : this.fBeanList) {
            this.addPropertyChangeListenerToBean(propertyName, bean);
        }
    }

    private void addPropertyChangeListenerToBean(String propertyName, T bean) {
        ColumnBinding columnBinding = this.findColumnBindingForPropertyName(propertyName);
        if (columnBinding != null) {
            try {
                BeanPropertyHandler beanPropertyChangeListener = new BeanPropertyHandler(bean, columnBinding.getTableColumn().getModelIndex());
                Method method = bean.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                method.invoke(bean, propertyName, beanPropertyChangeListener);
                columnBinding.addPropertyChangeListener(bean, beanPropertyChangeListener);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
    }

    private void removePropertyChangeListenerFromAllProperties(T bean) {
        PropertyDescriptor[] beanProperties;
        for (PropertyDescriptor propertyDescriptor : beanProperties = BindingUtils.getSimpleReadablePropertyDescriptors(this.fBeanClass)) {
            this.removePropertyChangeListenerFromBean(propertyDescriptor.getName(), bean);
        }
    }

    private void removePropertyChangeListenerFromAllBeans(String propertyName) {
        for (Object bean : this.fBeanList) {
            this.removePropertyChangeListenerFromBean(propertyName, bean);
        }
    }

    private void removePropertyChangeListenerFromBean(String propertyName, T bean) {
        BeanPropertyHandler propertyChangeListener;
        ColumnBinding columnBinding = this.findColumnBindingForPropertyName(propertyName);
        if (columnBinding != null && (propertyChangeListener = columnBinding.getPropertyChangeListener(bean)) != null) {
            try {
                Method method = bean.getClass().getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
                method.invoke(bean, propertyName, propertyChangeListener);
                columnBinding.removePropertyChangeListener(bean);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
    }

    private ColumnBinding findColumnBindingForPropertyName(String propertyName) {
        for (ColumnBinding columnBinding : this.fColumnBindings) {
            if (!columnBinding.getPropertyName().equals(propertyName)) continue;
            return columnBinding;
        }
        return null;
    }

    public void removeColumnBinding(String propertyName) {
        ColumnBinding columnBinding = this.findColumnBindingForPropertyName(propertyName);
        if (columnBinding != null) {
            this.removeColumnBinding(columnBinding);
        }
    }

    public void removeColumnBinding(ColumnBinding columnBinding) {
        this.removePropertyChangeListenerFromAllBeans(columnBinding.getPropertyName());
        this.fColumnBindings.remove(columnBinding);
        this.fTable.removeColumn(columnBinding.getTableColumn());
    }

    public void removeColumnBinding(ULCTableColumn tableColumn) {
        ColumnBinding columnBinding = this.getColumnBinding(tableColumn);
        if (columnBinding != null) {
            this.removeColumnBinding(columnBinding);
        }
    }

    public ColumnBinding getColumnBinding(ULCTableColumn tableColumn) {
        for (ColumnBinding columnBinding : this.fColumnBindings) {
            if (!tableColumn.equals(columnBinding.getTableColumn())) continue;
            return columnBinding;
        }
        return null;
    }

    public List<ColumnBinding> getColumnBindings() {
        return this.fColumnBindings;
    }

    public ITableModel getTableModel() {
        return this.fBeanTableModel;
    }

    public void setAutoCreateColumnsFromBean(boolean autoCreateColumnsFromBean) {
        if (this.fSetAutoCreatColumnFromBean != autoCreateColumnsFromBean) {
            this.fSetAutoCreatColumnFromBean = autoCreateColumnsFromBean;
            if (this.fSetAutoCreatColumnFromBean) {
                this.createDefaultColumnsFromBean();
            }
        }
    }

    public ObservableList<T> getBeanList() {
        return this.fBeanList;
    }

    public T getBeanForRow(int row) {
        return (T)this.fBeanList.get(row);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeanTableModel
    extends AbstractTableModel {
        private BeanTableModel() {
        }

        @Override
        public int getColumnCount() {
            return TableBinding.this.fColumnBindings.size();
        }

        @Override
        public int getRowCount() {
            return TableBinding.this.fBeanList.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return ((ColumnBinding)TableBinding.this.fColumnBindings.get(columnIndex)).getColumnType();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return ((ColumnBinding)TableBinding.this.fColumnBindings.get(columnIndex)).getColumnName();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return ((ColumnBinding)TableBinding.this.fColumnBindings.get(columnIndex)).isEditable();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return ((ColumnBinding)TableBinding.this.fColumnBindings.get(columnIndex)).getProperty(rowIndex);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ((ColumnBinding)TableBinding.this.fColumnBindings.get(columnIndex)).setProperty(value, rowIndex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ColumnBinding
    implements Serializable {
        private String fPropertyName;
        private String fColumnName;
        private boolean fEditable;
        private Class<?> fColumnType;
        private final ULCTableColumn fTableColumn;
        private Map<T, BeanPropertyHandler> fPropertyChangeListenerByBean;

        public ColumnBinding(String propertyName, String columnName, ULCTableColumn tableColumn) {
            this.fPropertyName = propertyName;
            this.fColumnName = columnName;
            this.fTableColumn = tableColumn;
            this.fColumnType = this.initColumnType();
            this.fPropertyChangeListenerByBean = new HashMap();
        }

        private Class<?> initColumnType() {
            PropertyDescriptor propertyDescriptor = BindingUtils.staticResolvePropertyDescriptor(this.fPropertyName, TableBinding.this.fBeanClass);
            if (propertyDescriptor != null) {
                Class<?> serverType = BindingUtils.resolvePropertyType(propertyDescriptor);
                return this.convertToClientType(serverType);
            }
            return Object.class;
        }

        private Class<?> convertToClientType(Class<?> propertyType) {
            if (!propertyType.isPrimitive()) {
                if (propertyType != String.class && propertyType != Class.class && !this.hasCoder(propertyType)) {
                    propertyType = Object.class;
                }
                return propertyType;
            }
            if (propertyType == Boolean.TYPE) {
                return Boolean.class;
            }
            if (propertyType == Character.TYPE) {
                return Character.class;
            }
            if (propertyType == Byte.TYPE) {
                return Byte.class;
            }
            if (propertyType == Short.TYPE) {
                return Short.class;
            }
            if (propertyType == Integer.TYPE) {
                return Integer.class;
            }
            if (propertyType == Long.TYPE) {
                return Long.class;
            }
            if (propertyType == Float.TYPE) {
                return Float.class;
            }
            if (propertyType == Double.TYPE) {
                return Double.class;
            }
            throw new IllegalArgumentException(propertyType + " is not permitted");
        }

        private boolean hasCoder(Class<?> type) {
            DefaultServerCoderRegistryProvider coderRegistryProvider = new DefaultServerCoderRegistryProvider();
            CoderRegistry coderRegistry = coderRegistryProvider.getCoderRegistry();
            IStreamCoder coder = coderRegistry.getCoder(type);
            return coder != null;
        }

        protected BeanPropertyHandler getPropertyChangeListener(T bean) {
            return this.fPropertyChangeListenerByBean.get(bean);
        }

        protected void addPropertyChangeListener(T bean, BeanPropertyHandler beanPropertyChangeListener) {
            this.fPropertyChangeListenerByBean.put(bean, beanPropertyChangeListener);
        }

        protected void removePropertyChangeListener(T bean) {
            this.fPropertyChangeListenerByBean.remove(bean);
        }

        public ULCTableColumn getTableColumn() {
            return this.fTableColumn;
        }

        public int getTableColumnIndex() {
            return TableBinding.this.fTable.getColumnModel().getColumnIndex(this.fTableColumn);
        }

        public Object getProperty(int row) {
            try {
                Object bean = TableBinding.this.fBeanList.get(row);
                Object property = PropertyUtils.getProperty(bean, (String)this.fPropertyName);
                if (this.fColumnType == Object.class) {
                    property = String.valueOf(property);
                }
                return property;
            }
            catch (Exception e2) {
                throw new PropertyAccessException("Can't get property and propertyType for property " + this.fPropertyName, e2);
            }
        }

        public void setProperty(Object value, int row) {
            Object bean = TableBinding.this.fBeanList.get(row);
            try {
                PropertyUtils.setProperty(bean, (String)this.fPropertyName, (Object)value);
            }
            catch (Exception e2) {
                throw new PropertyAccessException("Can't set property: " + this.fPropertyName + " -> value: " + value, e2);
            }
        }

        public Class<?> getColumnType() {
            return this.fColumnType;
        }

        public String getColumnName() {
            return this.fColumnName;
        }

        public ColumnBinding columnName(String columnName) {
            this.fColumnName = columnName;
            return this;
        }

        public String getPropertyName() {
            return this.fPropertyName;
        }

        public ColumnBinding cellEditor(ITableCellEditor cellEditor) {
            this.fTableColumn.setCellEditor(cellEditor);
            return this;
        }

        public ColumnBinding cellRenderer(ITableCellRenderer cellRenderer) {
            this.fTableColumn.setCellRenderer(cellRenderer);
            return this;
        }

        public ColumnBinding headerRenderer(ITableCellRenderer headerRenderer) {
            this.fTableColumn.setHeaderRenderer(headerRenderer);
            return this;
        }

        public ColumnBinding headerValue(Object headerValue) {
            this.fTableColumn.setHeaderValue(headerValue);
            return this;
        }

        public ColumnBinding identifier(Object identifier) {
            this.fTableColumn.setIdentifier(identifier);
            return this;
        }

        public ColumnBinding maxWidth(int maxWidth) {
            this.fTableColumn.setMaxWidth(maxWidth);
            return this;
        }

        public ColumnBinding minWidth(int minWidth) {
            this.fTableColumn.setMinWidth(minWidth);
            return this;
        }

        public ColumnBinding modelIndex(int modelIndex) {
            this.fTableColumn.setModelIndex(modelIndex);
            return this;
        }

        public ColumnBinding preferredWidth(int preferredWidth) {
            this.fTableColumn.setPreferredWidth(preferredWidth);
            return this;
        }

        public ColumnBinding resizable(boolean isResizable) {
            this.fTableColumn.setResizable(isResizable);
            return this;
        }

        public ColumnBinding sizeWidthToFit() {
            this.fTableColumn.sizeWidthToFit();
            return this;
        }

        public ColumnBinding setEditable(boolean editable) {
            this.fEditable = editable;
            return this;
        }

        public boolean isEditable() {
            return this.fEditable;
        }

        public ColumnBinding columnType(Class<?> columnType) {
            this.fColumnType = columnType;
            return this;
        }

        public String toString() {
            return super.toString() + " -> columnName: " + this.fColumnName + " -> columnNo: " + this.fTableColumn.getModelIndex();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeanPropertyHandler
    implements PropertyChangeListener,
    Serializable {
        private final T fBean;
        private final int fColumn;

        public BeanPropertyHandler(T bean, int column) {
            this.fBean = bean;
            this.fColumn = column;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TableBinding.this.fBeanTableModel.fireTableCellUpdated(TableBinding.this.fBeanList.indexOf(this.fBean), this.fColumn);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeanListHandler
    implements ObservableListListener<T> {
        private BeanListHandler() {
        }

        @Override
        public void listElementReplaced(ObservableList<T> list, int index, T oldElement) {
            Object newElement = list.get(index);
            TableBinding.this.removePropertyChangeListenerFromAllProperties(oldElement);
            TableBinding.this.addPropertyChangeListenerToAllProperties(newElement);
            TableBinding.this.fBeanTableModel.fireTableRowsUpdated(index, index);
        }

        @Override
        public void listElementsAdded(ObservableList<T> list, int index, int length) {
            for (int i2 = index; i2 < index + length; ++i2) {
                TableBinding.this.addPropertyChangeListenerToAllProperties(list.get(i2));
            }
            TableBinding.this.fBeanTableModel.fireTableRowsInserted(index, index + length - 1);
        }

        @Override
        public void listElementsRemoved(ObservableList<T> list, int index, List<T> oldElements) {
            int i2 = index;
            int n2 = 0;
            while (i2 < index + oldElements.size()) {
                TableBinding.this.removePropertyChangeListenerFromAllProperties(oldElements.get(n2));
                ++i2;
                ++n2;
            }
            TableBinding.this.fBeanTableModel.fireTableRowsDeleted(index, index + oldElements.size() - 1);
        }
    }
}

