/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application.form.model;

import com.ulcjava.applicationframework.application.form.model.PropertyValidator;
import com.ulcjava.base.shared.ErrorObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeValidator<T extends Comparable<? super T>>
extends PropertyValidator<Comparable<? super T>> {
    private T fMax;
    private T fMin;

    public RangeValidator(T min, T max, String ... propertyName) {
        super(propertyName);
        if (min == null & max == null) {
            throw new IllegalArgumentException("min and max cannot both be null");
        }
        if (min == null || max == null || min.compareTo(max) <= 0) {
            this.fMin = min;
            this.fMax = max;
        } else {
            this.fMin = max;
            this.fMax = min;
        }
    }

    @Override
    public String validateValue(Comparable<? super T> value) {
        if (value != null && (this.isOutsideLowerBound(value) || this.isOutsideUpperBound(value))) {
            return this.createErrorCode(value);
        }
        return null;
    }

    protected String createErrorCode(Comparable<? super T> value) {
        return "ERROR_CODE.value.not.in.range";
    }

    @Override
    protected ErrorObject createError(String propertyName, Comparable<? super T> illegalValue, String errorCode) {
        return new ErrorObject(errorCode, illegalValue, new Object[]{this.getMin(), this.getMax()});
    }

    protected boolean isOutsideLowerBound(Comparable<? super T> value) {
        return this.getMin() != null && value.compareTo(this.getMin()) < 0;
    }

    protected boolean isOutsideUpperBound(Comparable<? super T> value) {
        return this.getMax() != null && value.compareTo(this.getMax()) > 0;
    }

    public T getMax() {
        return this.fMax;
    }

    public T getMin() {
        return this.fMin;
    }
}

