/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.easydeployment.server;

import com.ulcjava.base.server.ApplicationConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class EasyDeploymentUtilities {
    private static final String CLIENT_RESOURCE_PREFIX = "/WEB-INF/lib/";
    private static final String CLIENT_RESOURCE_POSTFIX = "-client.jar";
    private static String sJNLPLauncherLibName = "ulc-all5-client.jar";

    public static synchronized String getJNLPLauncherLibName() {
        return sJNLPLauncherLibName;
    }

    public static synchronized void setJNLPLauncherLibName(String launcherLibName) {
        sJNLPLauncherLibName = launcherLibName;
    }

    private EasyDeploymentUtilities() {
    }

    public static String toTitle() {
        return "ULC Application Start";
    }

    public static String toAppletArchiveAttribute(ServletContext servletContext) {
        StringBuffer result = new StringBuffer();
        Set libPaths = servletContext.getResourcePaths(CLIENT_RESOURCE_PREFIX);
        for (String resourcePath : libPaths) {
            if (!EasyDeploymentUtilities.isClientResource(resourcePath)) continue;
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(EasyDeploymentUtilities.toClientResource(resourcePath));
        }
        return result.toString();
    }

    public static String toAppletLauncherClassName(ServletContext context, HttpServletRequest request) {
        ApplicationConfiguration config = ApplicationConfiguration.getInstance();
        return config == null || config.getAppletLauncherClassName() == null ? "com.ulcjava.environment.applet.client.DefaultAppletLauncher" : config.getAppletLauncherClassName();
    }

    public static String toUrlStringParam(HttpServletRequest request) {
        return EasyDeploymentUtilities.toBaseURL(request) + "ulc";
    }

    public static String toBaseURL(HttpServletRequest request) {
        String baseURL = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
        return baseURL;
    }

    public static String toKeepAliveIntervalParam() {
        return Integer.toString(900);
    }

    public static String toApplicationAppletClassName(ServletContext context, HttpServletRequest request) {
        String result = EasyDeploymentUtilities.toBaseName(request);
        if (result == null) {
            throw new RuntimeException("unable to get Application");
        }
        return result;
    }

    public static String toApplicationClassName(String classRoot) {
        String applicationClassName = null;
        if (classRoot.endsWith("Application") || classRoot.endsWith("Applet")) {
            applicationClassName = classRoot.replace('/', '.');
        }
        return applicationClassName;
    }

    public static String toMatchingClassName(JarInputStream jarResource, String classNamePostfix) throws IOException {
        JarEntry entry = jarResource.getNextJarEntry();
        while (entry != null) {
            if (entry.getName().indexOf(classNamePostfix + ".class") >= 0) {
                String result = entry.getName();
                result = result.replace('/', '.');
                return result.substring(0, result.indexOf(".class"));
            }
            entry = jarResource.getNextJarEntry();
        }
        return null;
    }

    private static String toClientResource(String resourcePath) {
        return resourcePath.substring(CLIENT_RESOURCE_PREFIX.length());
    }

    private static boolean isClientResource(String resourcePath) {
        return resourcePath.endsWith(CLIENT_RESOURCE_POSTFIX);
    }

    private static String toBaseName(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        int resultEndIndex = servletPath.lastIndexOf(46);
        return servletPath.substring("/".length(), resultEndIndex);
    }

    public static String toFullURLIfNotNull(HttpServletRequest request, String resourceName) {
        String ifNull = null;
        return EasyDeploymentUtilities.toFullURLIfNotNull(request, resourceName, ifNull);
    }

    public static String toFullURLIfNotNull(HttpServletRequest request, String resourceName, String defaultValue) {
        return resourceName != null ? EasyDeploymentUtilities.toBaseURL(request) + resourceName : defaultValue;
    }

    public static String toJNLPJarTags(ServletContext servletContext) {
        String jarList = EasyDeploymentUtilities.toAppletArchiveAttribute(servletContext);
        String[] jars = jarList.split(",");
        String result = "";
        for (int i2 = 0; i2 < jars.length; ++i2) {
            String jar = jars[i2];
            result = result + "<jar href=\"" + jar + "\"";
            if (jar.endsWith(EasyDeploymentUtilities.getJNLPLauncherLibName())) {
                result = result + " main=\"true\"";
            }
            result = result + " />";
        }
        return result;
    }

    public static String toJNLPLauncherClassName(ServletContext servletContext, HttpServletRequest request) {
        ApplicationConfiguration config = ApplicationConfiguration.getInstance();
        return config == null || config.getJnlpLauncherClassName() == null ? "com.ulcjava.environment.jnlp.client.DefaultJnlpLauncher" : config.getJnlpLauncherClassName();
    }

    private static class JarType {
        public static final JarType CLIENT = new JarType("-client.jar");
        public static final JarType SERVER = new JarType("-server.jar");
        private final String fPathPostfix;

        private JarType(String pathPostfix) {
            this.fPathPostfix = pathPostfix;
        }

        public JarInputStream toJarResource(ServletContext servletContext, HttpServletRequest request) {
            try {
                String jarPath = EasyDeploymentUtilities.CLIENT_RESOURCE_PREFIX + EasyDeploymentUtilities.toBaseName(request) + this.fPathPostfix;
                InputStream jarStream = servletContext.getResourceAsStream(jarPath);
                return jarStream == null ? null : new JarInputStream(jarStream);
            }
            catch (IOException e2) {
                throw new RuntimeException("unable to load jar resource", e2);
            }
        }

        public String toMatchingClassName(ServletContext context, HttpServletRequest request, String classNamePostfix) {
            try {
                String jarPath = EasyDeploymentUtilities.CLIENT_RESOURCE_PREFIX + EasyDeploymentUtilities.toBaseName(request) + this.fPathPostfix;
                InputStream jarStream = context.getResourceAsStream(jarPath);
                return jarStream == null ? null : EasyDeploymentUtilities.toMatchingClassName(new JarInputStream(jarStream), classNamePostfix);
            }
            catch (IOException e2) {
                throw new RuntimeException("unable to load jar resource", e2);
            }
        }
    }
}

