/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.easydeployment.server;

import com.ulcjava.base.shared.internal.ClassUtilities;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceDownloader
extends HttpServlet
implements Servlet {
    private static final int BUFFER_SIZE = 4096;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        String resourcePath = request.getServletPath() + request.getPathInfo();
        String mimeType = this.getServletContext().getMimeType(resourcePath);
        if (mimeType == null) {
            try {
                response.sendError(403, "Only file that have a mime-type mapping can be accessed, No mime type defined for " + resourcePath);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return;
        }
        response.setContentType(mimeType);
        InputStream file = ClassUtilities.getDefaultClassLoader().getResourceAsStream(resourcePath);
        if (file != null) {
            byte[] buffer = new byte[4096];
            try {
                int len = file.read(buffer);
                while (len >= 0) {
                    response.getOutputStream().write(buffer, 0, len);
                    len = file.read(buffer);
                }
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        } else {
            try {
                response.sendError(404);
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
        }
    }
}

