/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.base.trusted;

import com.ulcjava.base.client.FileContents;
import com.ulcjava.base.client.IFileService;
import com.ulcjava.base.client.ServiceException;
import com.ulcjava.base.client.UIComponent;
import com.ulcjava.base.shared.FileChooserConfig;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class AllPermissionsFileService
implements IFileService {
    protected JFileChooser createFileChooser(FileChooserConfig fileChooserConfig) {
        JFileChooser fileChooser = new JFileChooser();
        if (fileChooserConfig.getSelectedFile() != null) {
            File file = new File(fileChooserConfig.getSelectedFile());
            fileChooser.setSelectedFile(file);
        }
        if (fileChooserConfig.getCurrentDirectory() != null) {
            File dir = new File(fileChooserConfig.getCurrentDirectory());
            fileChooser.setCurrentDirectory(dir);
        }
        if (fileChooserConfig.getDialogTitle() != null) {
            fileChooser.setDialogTitle(fileChooserConfig.getDialogTitle());
        }
        if (fileChooserConfig.getApproveButtonToolTipText() != null) {
            fileChooser.setApproveButtonToolTipText(fileChooserConfig.getApproveButtonToolTipText());
        }
        if (fileChooserConfig.getApproveButtonMnemonic() != '\u0000') {
            fileChooser.setApproveButtonMnemonic(fileChooserConfig.getApproveButtonMnemonic());
        }
        fileChooser.setFileHidingEnabled(fileChooserConfig.isFileHidingEnabled());
        fileChooser.setFileSelectionMode(fileChooserConfig.getFileSelectionMode());
        fileChooser.setDialogType(fileChooserConfig.getDialogType());
        fileChooser.setAcceptAllFileFilterUsed(fileChooserConfig.isAcceptAllFileFilterUsed());
        fileChooser.setMultiSelectionEnabled(fileChooserConfig.isMultiSelectionEnabled());
        fileChooser.setControlButtonsAreShown(fileChooserConfig.getControlButtonsAreShown());
        for (int i = 0; i < fileChooserConfig.getFileFilterConfigs().length; ++i) {
            FileChooserConfig.FileFilterConfig fileFilterConfig = fileChooserConfig.getFileFilterConfigs()[i];
            String[] allowedExtensions = fileFilterConfig.getAllowedExtensions();
            String description = fileFilterConfig.getDescription();
            FileFilter fileFilter = this.createFileFilter(allowedExtensions, description);
            fileChooser.addChoosableFileFilter(fileFilter);
        }
        return fileChooser;
    }

    protected FileFilter createFileFilter(String[] allowedExtensions, String description) {
        return new ExtensionFileFilter(allowedExtensions, description);
    }

    public FileContents[] chooseFiles(final FileChooserConfig fileChooserConfig, final UIComponent parent) throws ServiceException {
        try {
            FileContents[] chosenFiles = (FileContents[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    JFileChooser fileChooser = AllPermissionsFileService.this.createFileChooser(fileChooserConfig);
                    Component basicParent = null;
                    if (parent != null) {
                        basicParent = parent.getBasicComponent();
                    }
                    int fileChooserResult = fileChooser.showDialog(basicParent, fileChooserConfig.getApproveButtonText());
                    switch (fileChooserResult) {
                        case 0: {
                            File[] files = null;
                            files = fileChooser.isMultiSelectionEnabled() ? fileChooser.getSelectedFiles() : new File[]{fileChooser.getSelectedFile()};
                            if (files == null) {
                                return null;
                            }
                            FileContents[] result = new FileContents[files.length];
                            for (int i = 0; i < files.length; ++i) {
                                result[i] = AllPermissionsFileService.this.getFileContent(files[i].getAbsolutePath());
                            }
                            return result;
                        }
                    }
                    return null;
                }
            });
            return chosenFiles;
        }
        catch (Exception e) {
            throw new ServiceException("could not choose file", e);
        }
    }

    public FileContents openFile(final String filePath) throws ServiceException {
        try {
            FileContents fileContents = (FileContents)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AllPermissionsFileService.this.getFileContent(filePath);
                }
            });
            return fileContents;
        }
        catch (Exception e) {
            throw new ServiceException("could not open file", e);
        }
    }

    public FileContents storeFile(final String filePath, final InputStream in) throws ServiceException {
        try {
            FileContents fileContents = (FileContents)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    int b2;
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filePath));
                    while ((b2 = in.read()) != -1) {
                        out.write(b2);
                    }
                    out.close();
                    File file = new File(filePath);
                    return new FileContents(file.getAbsolutePath(), null, file.length(), file.getName());
                }
            });
            return fileContents;
        }
        catch (Exception e) {
            throw new ServiceException("could not store file", e);
        }
    }

    public FileContents[] openFiles(FileChooserConfig fileChooserConfig, UIComponent parent) throws ServiceException {
        FileContents[] chosenFiles = this.chooseFiles(fileChooserConfig, parent);
        if (chosenFiles == null || chosenFiles.length == 0) {
            return null;
        }
        return chosenFiles;
    }

    public FileContents storeFile(FileChooserConfig fileChooserConfig, UIComponent parent, InputStream in) throws ServiceException {
        FileContents[] chosenFiles = this.chooseFiles(fileChooserConfig, parent);
        return chosenFiles == null ? null : this.storeFile(chosenFiles[0].getFilePath(), in);
    }

    private FileContents getFileContent(final String filePath) throws ServiceException {
        try {
            FileContents fileContents = (FileContents)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    File file = new File(filePath);
                    FileInputStream in = file.isDirectory() || !file.exists() ? null : new FileInputStream(filePath);
                    return new FileContents(file.getAbsolutePath(), in, file.length(), file.getName());
                }
            });
            return fileContents;
        }
        catch (Exception e) {
            throw new ServiceException("could not open file", e);
        }
    }

    public static class ExtensionFileFilter
    extends FileFilter {
        private String[] fAllowedExtensions;
        private String fDescription;

        public ExtensionFileFilter(String[] allowedExtensions, String description) {
            this.fAllowedExtensions = allowedExtensions;
            this.fDescription = description;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            for (int j = 0; j < this.fAllowedExtensions.length; ++j) {
                if (!file.getName().endsWith(this.fAllowedExtensions[j])) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.fDescription;
        }
    }
}

