/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.environment.applet.client;

import com.ulcjava.base.client.ClientEnvironmentAdapter;
import com.ulcjava.base.client.IConnector;
import com.ulcjava.base.client.ISessionStateListener;
import com.ulcjava.base.client.UISession;
import com.ulcjava.base.client.launcher.DefaultSessionStateListener;
import com.ulcjava.base.client.launcher.ErrorDialog;
import com.ulcjava.base.shared.internal.VersionInfo;
import com.ulcjava.environment.applet.client.AppletBrowserService;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.swing.JApplet;

public abstract class AbstractAppletLauncher
extends JApplet
implements ISessionStateListener {
    public static final String USER_PARAMETER_NAMES_KEY = "user-parameter-names";
    public static final String PARAMETER_DEFINITION_DELIMITER = ",";
    private static Map sAppletsBySession;
    private UISession fSession;

    protected AbstractAppletLauncher() {
    }

    protected abstract IConnector createConnector();

    public static void registerApplet(UISession session, JApplet applet) {
        sAppletsBySession.put(session, applet);
    }

    public static void unregisterApplet(JApplet applet) {
        sAppletsBySession.values().remove(applet);
    }

    public static JApplet getApplet() {
        return (JApplet)sAppletsBySession.get(UISession.currentSession());
    }

    protected UISession getSession() {
        return this.fSession;
    }

    public void init() {
        ClientEnvironmentAdapter.setBrowserService(new AppletBrowserService());
        ClientEnvironmentAdapter.getClientInfo().setClientEnvironmentType(1);
    }

    public void start() {
        IConnector connector = this.createConnector();
        this.fSession = new UISession(connector, this.extractParameters(USER_PARAMETER_NAMES_KEY));
        AbstractAppletLauncher.registerApplet(this.getSession(), this);
        this.fSession.addSessionStateListener(this.createSessionStateListener());
        this.fSession.addSessionStateListener(this);
        this.getSession().start();
    }

    protected ISessionStateListener createSessionStateListener() {
        return new DefaultSessionStateListener();
    }

    public void stop() {
        this.getSession().sendStopApplicationAndWait();
        AbstractAppletLauncher.unregisterApplet(this);
    }

    public void sessionEnded(UISession session) {
    }

    public void sessionStarted(UISession session) {
    }

    public void sessionError(UISession session, Throwable reason) {
    }

    public static void showMessageDialog(String windowTitle, String message, Throwable reason) {
        new ErrorDialog(windowTitle, message, reason).show();
    }

    public static void showMessageDialog(String windowTitle, String message, String reason) {
        new ErrorDialog(windowTitle, message, reason).show();
    }

    private Properties extractParameters(String parametersDefinitionKey) {
        Properties result = new Properties();
        String parametersDefinition = this.getParameter(parametersDefinitionKey);
        if (parametersDefinition == null) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(parametersDefinition, PARAMETER_DEFINITION_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String parameterName = tokenizer.nextToken();
            result.setProperty(parameterName, this.getParameter(parameterName));
        }
        return result;
    }

    public String[][] getParameterInfo() {
        return new String[][]{{USER_PARAMETER_NAMES_KEY, "String", "comma-separated list of names of all user parameters (e.g., 'userName,id')"}};
    }

    public void sendMessage(String message) {
        this.getSession().sendMessage(message);
    }

    static {
        VersionInfo.addVersionInfo(AbstractAppletLauncher.class, "build.3670");
        sAppletsBySession = new WeakHashMap();
    }
}

