/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.environment.jnlp.client;

import com.ulcjava.base.client.FilteringEventQueue;
import com.ulcjava.base.client.IFileService;
import com.ulcjava.base.client.ServiceException;
import com.ulcjava.base.client.UIComponent;
import com.ulcjava.base.shared.FileChooserConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public class JnlpFileService
implements IFileService {
    public com.ulcjava.base.client.FileContents[] chooseFiles(FileChooserConfig fileChooserConfig, UIComponent parent) throws ServiceException {
        throw new ServiceException("choose file not supported");
    }

    public com.ulcjava.base.client.FileContents openFile(String filePath) throws ServiceException {
        File file = new File(filePath);
        return this.openFileDialog(file.getParent(), new String[0], false)[0];
    }

    public com.ulcjava.base.client.FileContents[] openFiles(FileChooserConfig fileChooserConfig, UIComponent parent) throws ServiceException {
        this.checkFileSelectionMode(fileChooserConfig);
        String pathHint = fileChooserConfig.getCurrentDirectory();
        String[] extensions = this.getExtensions(fileChooserConfig);
        return this.openFileDialog(pathHint, extensions, fileChooserConfig.isMultiSelectionEnabled());
    }

    public com.ulcjava.base.client.FileContents storeFile(String filePath, InputStream in) throws ServiceException {
        File file = new File(filePath);
        return this.saveFileDialog(file.getParent(), new String[0], in, file.getName());
    }

    public com.ulcjava.base.client.FileContents storeFile(FileChooserConfig fileChooserConfig, UIComponent parent, InputStream in) throws ServiceException {
        this.checkFileSelectionMode(fileChooserConfig);
        String pathHint = fileChooserConfig.getCurrentDirectory();
        String[] extensions = this.getExtensions(fileChooserConfig);
        String name = fileChooserConfig.getSelectedFile() == null ? null : new File(fileChooserConfig.getSelectedFile()).getName();
        return this.saveFileDialog(pathHint, extensions, in, name);
    }

    private com.ulcjava.base.client.FileContents[] openFileDialog(String pathHint, String[] extensions, boolean multiFileSelection) throws ServiceException {
        FilteringEventQueue.ensureIsUninstalled();
        try {
            FileContents[] jnlpFileContents;
            if (!multiFileSelection) {
                jnlpFileContents = ((FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService")).openFileDialog(pathHint, extensions);
                if (jnlpFileContents != null) {
                    com.ulcjava.base.client.FileContents[] fileContentsArray = new com.ulcjava.base.client.FileContents[]{this.getFileContents((FileContents)jnlpFileContents)};
                    return fileContentsArray;
                }
                com.ulcjava.base.client.FileContents[] fileContentsArray = null;
                return fileContentsArray;
            }
            jnlpFileContents = ((FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService")).openMultiFileDialog(pathHint, extensions);
            if (jnlpFileContents == null || jnlpFileContents.length == 0) {
                com.ulcjava.base.client.FileContents[] fileContentsArray = null;
                return fileContentsArray;
            }
            com.ulcjava.base.client.FileContents[] fileContents = new com.ulcjava.base.client.FileContents[jnlpFileContents.length];
            for (int i = 0; i < jnlpFileContents.length; ++i) {
                fileContents[i] = this.getFileContents(jnlpFileContents[i]);
            }
            com.ulcjava.base.client.FileContents[] fileContentsArray = fileContents;
            return fileContentsArray;
        }
        catch (IOException e) {
            throw new ServiceException("could not load file", e);
        }
        catch (UnavailableServiceException e) {
            throw new ServiceException("could not load file", e);
        }
        finally {
            FilteringEventQueue.ensureIsInstalled();
        }
    }

    private com.ulcjava.base.client.FileContents getFileContents(FileContents jnlpFileContents) throws IOException, UnavailableServiceException {
        return new com.ulcjava.base.client.FileContents(null, jnlpFileContents.getInputStream(), jnlpFileContents.getLength(), jnlpFileContents.getName());
    }

    private com.ulcjava.base.client.FileContents saveFileDialog(String pathHint, String[] extensions, InputStream in, String name) throws ServiceException {
        FilteringEventQueue.ensureIsUninstalled();
        try {
            FileContents jnlpFileContents = ((FileSaveService)ServiceManager.lookup((String)"javax.jnlp.FileSaveService")).saveFileDialog(pathHint, extensions, in, name);
            if (jnlpFileContents != null) {
                com.ulcjava.base.client.FileContents fileContents = new com.ulcjava.base.client.FileContents(null, jnlpFileContents.getInputStream(), jnlpFileContents.getLength(), jnlpFileContents.getName());
                return fileContents;
            }
            com.ulcjava.base.client.FileContents fileContents = null;
            return fileContents;
        }
        catch (IOException e) {
            throw new ServiceException("could not store file", e);
        }
        catch (UnavailableServiceException e) {
            throw new ServiceException("could not store file", e);
        }
        finally {
            FilteringEventQueue.ensureIsInstalled();
        }
    }

    private String[] getExtensions(FileChooserConfig fileChooserConfig) {
        TreeSet<String> result = new TreeSet<String>();
        for (int i = 0; i < fileChooserConfig.getFileFilterConfigs().length; ++i) {
            String[] extensions = fileChooserConfig.getFileFilterConfigs()[i].getAllowedExtensions();
            for (int j = 0; j < extensions.length; ++j) {
                result.add(extensions[j]);
            }
        }
        return result.toArray(new String[0]);
    }

    private void checkFileSelectionMode(FileChooserConfig fileChooserConfig) throws ServiceException {
        if (fileChooserConfig.getFileSelectionMode() != 0) {
            throw new ServiceException("only FileChooserConfig.FILES_ONLY file selection mode supported");
        }
    }
}

