package com.ulcjava.base.client;


	/**
	* If a client side proxy of a component wishes to queue server requests for the
	* next round-trip, it can do that using an implementation of
this interface.
	* Thecomponent's client side proxy can register an object of the class
	* implementing this interface with the
<code>UISession</code> using
	* <code>getSession().addPendingRequestsOwner()</code>. During the next
	* round-trip before sending the
requests, <code>addPendingRequests()</code> is
	* called on all <code>IPendingRequestOwner</code>s, wherein they can queue up
	* its
requests to the list of requests being sent to the server. This mechanism
	* is used by data intensive components of ULC such as
<code>ULCList</code>,
	* <code>ULCTable</code>, <code>ULCTableTree</code>, and <code>ULCTree</code> to
	* request data and renderers
in a lazy manner.
	*
	* @ulc.extension		
	* @see		com.ulcjava.base.client.UISession
	**/
 public interface IPendingRequestsOwner
{


	/**
	* Add requests to the request queue.
	*
	**/
	 public void addPendingRequests();

}