package com.ulcjava.base.client.streamcoder;


	/**
	* A factory class to create the provider of the client-side coder registry. The
	* respective coder registry is used by ULC in order to
communicate by means of
	* ULC streams. In order to allow developers to add new coders to a coder
	* registry, the coder registry provider,
which returns a ready-made coder
	* registry, must be extendable. E.g., in the case of the client-side coder
	* registry used by ULC, the class
{@link DefaultClientCoderRegistryProvider}
	* should be extended for this purpose. ULC uses this factory class to obtain
	* the(potentially
extended) client-side coder registry provider.
	*
	* @ulc.extension		
	* @see		DefaultClientCoderRegistryProvider
	* @see		com.ulcjava.base.shared.ICoderRegistryProvider
	**/
 public class ClientCoderRegistryProviderFactory extends java.lang.Object
{


	/**
	* Creates a coder registry provider from a given class name. If the class name
	* is<code>null</code>, then an instance of
{@link
	* DefaultClientCoderRegistryProvider} is returned. If class name is not
	* <code>null</code> but instantiation fails, then an
{@link
	* IllegalArgumentException} is thrown.
	*
	* @param registryProviderClassName 		 the class name of the coder registry provider
	* @return		the created coder registry provider instance
	**/
	 public  static com.ulcjava.base.shared.ICoderRegistryProvider createCoderRegistryProvider(java.lang.String registryProviderClassName)
	{
		return null;
	}


}