package com.ulcjava.base.client.streamcoder;


	/**
	* A {@link IStreamCoder stream coder} for marshalling AWT {@link Font} objects
	* toand from ULC data streams.
	*
	* @ulc.extension		
	**/
 public class FontCoder extends java.lang.Object implements com.ulcjava.base.shared.IStreamCoder
{


	/**
	* Returns <code>"jcom.ulcjava.base.application.util.Font"</code>.
	*
	* @see		IStreamCoder#getPeerClassName()
	**/
	 public java.lang.String getPeerClassName()
	{
		return null;
	}


	/**
	* Writes the given object (which must be a <code>Font</code>) to the stream. Let
	* <code>font</code> denote the argument cast as
<code>Font</code>.
	*
	* @see		IStreamCoder#writeObject(com.ulcjava.base.shared.IObjectOutputStream,Object)
	**/
	 public void writeObject(com.ulcjava.base.shared.IObjectOutputStream out, java.lang.Object data)throws java.io.IOException
	{
	}


	/**
	* Returns a fresh <code>Font</code> instance constructed from the stream data.
	*
	* @see		IStreamCoder#readObject(com.ulcjava.base.shared.IObjectInputStream)
	**/
	 public java.lang.Object readObject(com.ulcjava.base.shared.IObjectInputStream in)throws java.io.IOException
	{
		return null;
	}


	/**
	* Reads a font name, style, size and affine transform from the stream and
	* packages them as text attributes in the provided map. More
precisely, this
	* method is equivalent to:

<pre>
String name = (String)in.readObject();
int
	* style = in.readInt();
float size = in.readFloat();
AffineTransform transform
	* =(AffineTransform)in.readObject();
attributes.put(TextAttribute.FAMILY,
	* name);attributes.put(TextAttribute.SIZE, new Float(size));
if ((style &amp;
	* Font.BOLD) != 0)
attributes.put(TextAttribute.WEIGHT,
	* TextAttribute.WEIGHT_BOLD);
if ((style &amp; Font.ITALIC) !=
	* 0)
attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
if
	* (transform != null)
attributes.put(TextAttribute.TRANSFORM, transform);
</pre>
	*
	* @param in 		 the input stream to read from
	* @param attributes 		 the map to populate
	* @throws		NullPointerException if either argument is null
	* @throws		ClassCastException if the two objects read from the stream are not of type <code>
String</code> and
<code>AffineTransform</code>, respectively
	* @throws		IOException if thrown by a read operation
	**/
	 protected void readFontAttributes(com.ulcjava.base.shared.IObjectInputStream in, java.util.Map attributes)throws java.io.IOException
	{
	}


}