package com.ulcjava.base.shared;


	/**
	* Configuration information for a file chooser.
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ClientContext#loadFile(com.ulcjava.base.application.util.IFileLoadHandler, FileChooserConfig,
com.ulcjava.base.application.ULCComponent)
	* @see		com.ulcjava.base.application.ClientContext#storeFile(com.ulcjava.base.application.util.IFileStoreHandler, FileChooserConfig,
com.ulcjava.base.application.ULCComponent)
	**/
 public class FileChooserConfig extends java.lang.Object implements java.io.Serializable
{

	/**
	* Instruction to display only files.
	*
	**/
	 public  final  static int FILES_ONLY = 0;

	/**
	* Instruction to display only directories.
	*
	**/
	 public  final  static int DIRECTORIES_ONLY = 0;

	/**
	* Instruction to display both files and directories.
	*
	**/
	 public  final  static int FILES_AND_DIRECTORIES = 0;

	/**
	* DialogType value for "Open" file operation.
	*
	**/
	 public  final  static int OPEN_DIALOG = 0;

	/**
	* DialogType value for "Save" file operation.
	*
	**/
	 public  final  static int SAVE_DIALOG = 0;


	/**
	* Constructs a new file chooser configuration.
	*
	**/
	 public FileChooserConfig()
	{
		 super();
	}


	/**
	* Returns the selected file of this file chooser configuration.
	*
	* @return		the selected file of this file chooser configuration
	**/
	 public java.lang.String getSelectedFile()
	{
		return null;
	}


	/**
	* Sets the selected file of this file chooser configuration.
	*
	* @param selectedFile 		 the selected file of this file chooser configuration
	**/
	 public void setSelectedFile(java.lang.String selectedFile)
	{
	}


	/**
	* Returns the current directory of this file chooser configuration.
	*
	* @return		the current directory of this file chooser configuration
	**/
	 public java.lang.String getCurrentDirectory()
	{
		return null;
	}


	/**
	* Sets the current directory of this file chooser configuration.
	*
	* @param currentDirectory 		 the current directory of this file chooser configuration
	**/
	 public void setCurrentDirectory(java.lang.String currentDirectory)
	{
	}


	/**
	* Returns the dialog title of this file chooser configuration.
	*
	* @return		the dialog title of this file chooser configuration
	**/
	 public java.lang.String getDialogTitle()
	{
		return null;
	}


	/**
	* Sets the dialog title of this file chooser configuration.
	*
	* @param dialogTitle 		 the dialog title of this file chooser configuration
	**/
	 public void setDialogTitle(java.lang.String dialogTitle)
	{
	}


	/**
	* Returns the type of this file chooser configuration. The default is
	* <code>FileChooserConfig.OPEN_DIALOG</code>.
	*
	* @return		the type of dialog to be displayed:
<ul>
<li>FileChooserConfig.OPEN_DIALOG
<li>FileChooserConfig.SAVE_DIALOG
</ul>
	* @see		#setDialogType
	**/
	 public int getDialogType()
	{
		return 0;
	}


	/**
	* Sets the type of this file chooser configuration. Use <code>OPEN_DIALOG</code>
	* when you want to bring up a file chooser that the
user can use to open a
	* file.Use <code>SAVE_DIALOG</code> for letting the user choose a file for
	* saving.
<p>
</p>
The default dialog type is
	* <code>FileChooserConfig.OPEN_DIALOG</code>.
<p>
</p>
Note:
	* <code>ClientContext.loadFile()</code> and
	* <code>ClientContext.storeFile()</code> automatically configure the correct
	* type.
	*
	* @param dialogType 		 the type of dialog to be displayed:
<ul>
<li>FileChooserConfig.OPEN_DIALOG
<li>FileChooserConfig.SAVE_DIALOG
</ul>
	* @throws		IllegalArgumentException for illegal <code>dialogTypes</code>
	* @see		#getDialogType
	**/
	 public void setDialogType(int dialogType)
	{
	}


	/**
	* Returns the approve button tool tip text of this file chooser configuration.
	*
	* @return		the approve button tool tip text of this file chooser configuration
	**/
	 public java.lang.String getApproveButtonToolTipText()
	{
		return null;
	}


	/**
	* Sets the approve button tool tip text of this file chooser configuration.
	*
	* @param approveButtonToolTipText 		 the approve button tool tip text of this file chooser configuration
	**/
	 public void setApproveButtonToolTipText(java.lang.String approveButtonToolTipText)
	{
	}


	/**
	* Returns the approve button mnemonic of this file chooser configuration.
	*
	* @return		the approve button mnemonic of this file chooser configuration
	**/
	 public char getApproveButtonMnemonic()
	{
		return 'a';
	}


	/**
	* Sets the approve button mnemonic of this file chooser configuration.
	*
	* @param approveButtonMnemonic 		 the approve button mnemonic of this file chooser configuration
	**/
	 public void setApproveButtonMnemonic(char approveButtonMnemonic)
	{
	}


	/**
	* Returns the approve button text of this file chooser configuration.
	*
	* @return		the approve button text of this file chooser configuration
	**/
	 public java.lang.String getApproveButtonText()
	{
		return null;
	}


	/**
	* Sets the approve button text of this file chooser configuration.
	*
	* @param approveButtonText 		 the approve button text of this file chooser configuration
	**/
	 public void setApproveButtonText(java.lang.String approveButtonText)
	{
	}


	/**
	* Returns true if file hiding in this file chooser is enabled, false otherwise.
	*
	* @return		true if file hiding is enabled, false otherwise
	**/
	 public boolean isFileHidingEnabled()
	{
		return false;
	}


	/**
	* Sets the file handling behavior of this file chooser.
	*
	* @param fileHidingEnabled 		 true if file hiding is enabled, false otherwise
	**/
	 public void setFileHidingEnabled(boolean fileHidingEnabled)
	{
	}


	/**
	* Returns the current file selection mode. The default is
	* <code>FilesChooserConfig.FILES_ONLY</code>.
	*
	* @return		the type of files to be displayed, one of the following:
<ul>
<li>FileChooserConfig.FILES_ONLY
<li>FileChooserConfig.DIRECTORIES_ONLY
<li>FileChooserConfig.FILES_AND_DIRECTORIES
</ul>
	* @see		#setFileSelectionMode
	**/
	 public int getFileSelectionMode()
	{
		return 0;
	}


	/**
	* Sets file selection mode which allows the user to just select files, just
	* select directories, or select both files and directories.
The default is
	* <code>FilesChooserConfig.FILES_ONLY</code>.
	*
	* @param fileSelectionMode 		 the type of files to be displayed:
<ul>
<li>FileChooserConfig.FILES_ONLY
<li>FileChooserConfig.DIRECTORIES_ONLY
<li>FileChooserConfig.FILES_AND_DIRECTORIES
</ul>
	* @throws		IllegalArgumentException if <code>mode</code> is an illegal mode
	* @see		#getFileSelectionMode
	**/
	 public void setFileSelectionMode(int fileSelectionMode)
	{
	}


	/**
	* Returns an array containing the file filter configurations of this file chooser.
	*
	* @return		an array containing the file filter configurations of this file chooser
	**/
	 public com.ulcjava.base.shared.FileChooserConfig$FileFilterConfig[] getFileFilterConfigs()
	{
		return null;
	}


	/**
	* Adds a file filter configuration to this file chooser.
	*
	* @param fileFilterConfig 		 the file filter configuration to be added
	**/
	 public void addFileFilterConfig(com.ulcjava.base.shared.FileChooserConfig$FileFilterConfig fileFilterConfig)
	{
	}


	/**
	* Returns the value of <code>controlsShown</code>
	*
	* @return		the value of the <code>controlsShown</code>
	* @see		#setControlButtonsAreShown
	**/
	 public boolean getControlButtonsAreShown()
	{
		return false;
	}


	/**
	* Determines if control buttons are to be shown. However, this is ultimately
	* determined by the Look and Feels.
	*
	* @param controlsShown 		 <code>false</code> if control buttons should not be shown; otherwise, <code>true</code>
	* @see		#getControlButtonsAreShown
	**/
	 public void setControlButtonsAreShown(boolean controlsShown)
	{
	}


	/**
	* Determines if the file chooser can allow multiple file selections.
	*
	* @param multiSelectionEnabled 		 true if multiple files may be selected
	* @see		#isMultiSelectionEnabled
	**/
	 public void setMultiSelectionEnabled(boolean multiSelectionEnabled)
	{
	}


	/**
	* Returns whether multiple files can be selected.
	*
	* @return		true if multiple files can be selected
	* @see		#setMultiSelectionEnabled
	**/
	 public boolean isMultiSelectionEnabled()
	{
		return false;
	}


	/**
	* Returns whether the <code>AcceptAll FileFilter</code> ("all files") is used.
	*
	* @return		true if the <code>AcceptAll FileFilter</code> ("all files") is used
	* @see		#setAcceptAllFileFilterUsed
	**/
	 public boolean isAcceptAllFileFilterUsed()
	{
		return false;
	}


	/**
	* Determines if the <code>AcceptAllFileFilter</code> ("all files") is used.
	*
	* @param acceptAllFileFilterUsed 		 true if the <code>AcceptAllFileFilter</code> should be used, false otherwise.
	* @see		#isAcceptAllFileFilterUsed
	**/
	 public void setAcceptAllFileFilterUsed(boolean acceptAllFileFilterUsed)
	{
	}


	/**
	* Configuration information for a file filter. A file filter can be used on a
	* file chooser to keep unwanted files from appearing in the
directory listing.
	*
	* @ulc.application		
	**/
 public  static class FileFilterConfig extends java.lang.Object implements java.io.Serializable
{


	/**
	* Constructs a new file filter configuration.
	*
	* @param allowedExtensions 		 the allowed extensions of this file filter
	* @param description 		 the description of this file filter
	**/
	 public FileFilterConfig(java.lang.String[] allowedExtensions, java.lang.String description)
	{
		 super();
	}


	/**
	* Returns the allowed extensions of this file filter.
	*
	* @return		the allowed extensions of this file filter
	**/
	 public java.lang.String[] getAllowedExtensions()
	{
		return null;
	}


	/**
	* Returns the description of this file filter.
	*
	* @return		the description of this file filter
	**/
	 public java.lang.String getDescription()
	{
		return null;
	}


}
}