package com.ulcjava.base.shared;


	/**
	* Provides the ULC communication framework with concrete data output and data
	* input stream implementations. These stream implementations
are responsible
	* forwriting primitive types and text to and reading back from a low-level
	* byte-based stream.
<p>
</p>
Implementations of this interface are used on the
	* client and the server side in order to configure the
	* <code>IObjectOutputStream</code>
and <code>IObjectInputStream</code>
	* implementations used to write objects to a stream.
<p>
</p>
Classes
	* implementing this interface must have a no-argument constructor. ULC uses the
	* class
{@link com.ulcjava.base.shared.DataStreamProviderFactory} in order to
	* obtain an implementation from a given class name of this interface.
	*
	* @ulc.internal		
	**/
 public interface IDataStreamProvider
{


	/**
	* Gets a data output stream on the basis of a raw output stream.
	*
	* @param basicOutputStream 		 the raw output stream provided by ULC
	* @return		the data output stream
	**/
	 public com.ulcjava.base.shared.IDataOutputStream getDataOutputStream(java.io.OutputStream basicOutputStream)throws java.io.IOException;

	/**
	* Gets a data input stream on the basis of a raw input stream.
	*
	* @param basicInputStream 		 the raw input stream provided by ULC
	* @return		the data input stream
	**/
	 public com.ulcjava.base.shared.IDataInputStream getDataInputStream(java.io.InputStream basicInputStream)throws java.io.IOException;

}