package com.ulcjava.base.shared;


	/**
	* Defines a set of string constants, which represent standard ULC event
	* categories. In ULC each of these categories is associated with
exactly one
	* server-side listener interface. (The only exception is the internal category
	* {@link #MODEL_UPDATE_CATEGORY}.) (Note that
extension writers do not have to
	* adhere to this rule for their custom event categories.)
	*
	* @ulc.extension		
	**/
 public class UlcEventCategories extends java.lang.Object
{

	/**
	* For internal use only.
	*
	* @ulc.internal		
	**/
	 public  final  static java.lang.String MODEL_UPDATE_CATEGORY = null;

	/**
	* This event category has the value "action" and is associated with the listener
	* interface
{@link com.ulcjava.base.application.event.IActionListener}
	*
	**/
	 public  final  static java.lang.String ACTION_EVENT_CATEGORY = null;

	/**
	* This event category has the value "selectionChanged" and is associated with
	* thelistener interface
{@link
	* com.ulcjava.base.application.event.ISelectionChangedListener}
	*
	**/
	 public  final  static java.lang.String SELECTION_CHANGED_EVENT_CATEGORY = null;

	/**
	* This event category has the value "focus" and is associated with the listener
	* interface
{@link com.ulcjava.base.application.event.IFocusListener}
	*
	**/
	 public  final  static java.lang.String FOCUS_EVENT_CATEGORY = null;

	/**
	* This event category has the value "valueChanged" and is associated with the
	* listener interface
{@link
	* com.ulcjava.base.application.event.IValueChangedListener}
	*
	**/
	 public  final  static java.lang.String VALUE_CHANGED_EVENT_CATEGORY = null;

	/**
	* This event category has the value "treeExpansion" and is associated with the
	* listener interface
{@link
	* com.ulcjava.base.application.event.ITreeExpansionListener}
	*
	**/
	 public  final  static java.lang.String TREE_EXPANSION_EVENT_CATEGORY = null;

	/**
	* This event category has the value "window" and is associated with the listener
	* interface
{@link com.ulcjava.base.application.event.IWindowListener}
	*
	**/
	 public  final  static java.lang.String WINDOW_EVENT_CATEGORY = null;

	/**
	* This event category has the value "windowFocus" and is associated with the
	* listener interface
{@link
	* com.ulcjava.base.application.event.IWindowFocusListener}
	*
	**/
	 public  final  static java.lang.String WINDOW_FOCUS_EVENT_CATEGORY = null;

	/**
	* This event category has the value "internalFrame" and is associated with the
	* listener interface
{@link
	* com.ulcjava.base.application.event.IInternalFrameListener}
	*
	**/
	 public  final  static java.lang.String INTERNAL_FRAME_EVENT_CATEGORY = null;

	/**
	* This event category has the value "hyperlink" and is associated with the
	* listener interface
{@link
	* com.ulcjava.base.application.event.IHyperlinkListener}
	*
	**/
	 public  final  static java.lang.String HYPERLINK_EVENT_CATEGORY = null;

	/**
	* This event category has the value "key" and is associated with the listener
	* interface
{@link com.ulcjava.base.application.event.IKeyListener}
	*
	**/
	 public  final  static java.lang.String KEY_EVENT_CATEGORY = null;

	/**
	* This event category has the value "treeSelection" and is associated with the
	* listener interface
{@link
	* com.ulcjava.base.application.event.ITreeSelectionListener}
	*
	**/
	 public  final  static java.lang.String TREE_SELECTION_EVENT_CATEGORY = null;

	/**
	* This event category has the value "listSelection" and is associated with the
	* listener interface
{@link
	* com.ulcjava.base.application.event.IListSelectionListener}
	*
	**/
	 public  final  static java.lang.String LIST_SELECTION_EVENT_CATEGORY = null;

	/**
	* This event category has the value "roundtrip" and is associated with the
	* listener interface
{@link
	* com.ulcjava.base.application.event.IRoundTripListener}
	*
	**/
	 public  final  static java.lang.String ROUNDTRIP_EVENT_CATEGORY = null;

	/**
	* This event category has the value "adjustment" and is associated with the
	* listener interface
{@link
	* com.ulcjava.base.application.event.IAdjustmentListener}
	*
	**/
	 public  final  static java.lang.String ADJUSTMENT_EVENT_CATEGORY = null;

	/**
	* This event category has the value "keyboardAction" and is associated with the
	* listener interface
{@link com.ulcjava.base.application.event.IActionListener}
	*
	**/
	 public  final  static java.lang.String KEYBOARD_ACTION_EVENT_CATEGORY = null;

	/**
	* This event category has the value "columnModel" and is associated with the
	* listener interface
{@link
	* com.ulcjava.base.application.event.IColumnModelListener}
	*
	**/
	 public  final  static java.lang.String COLUMN_MODEL_EVENT_CATEGORY = null;

	/**
	* This event category has the value "popupMenu" and is associated with the
	* listener interface
{@link
	* com.ulcjava.base.application.event.IPopupMenuListener}
	*
	**/
	 public  final  static java.lang.String POPUP_MENU_EVENT_CATEGORY = null;

	 private UlcEventCategories()
	{
		 super();
	}


	/**
	* This method maps old-style IDs of event categories defined in {@link
	* IUlcEventConstants} to the corresponding event category names
defined in this
	* class. An old-style category ID constant named <code>&lt;XYZ&gt;</code> is
	* mapped to category a constant
	* named
<code>&lt;XYZ&gt;_CATEGORY</code>.
<p>
</p>
A category ID value, which
	* is not referenced in {@link IUlcEventConstants}, is converted to decimal
	* string representing the ID.
</p>
	*
	* @param eventCategoryID 		 the old-style event category ID
	* @return		the corresponding event category name of a decimal string
	**/
	 public  static java.lang.String getEventCategoryName(int eventCategoryID)
	{
		return null;
	}


}