package com.ulcjava.base.shared.internal;


	/**
	* A data object describing a ULC request from the client or the server.
	*
	* @ulc.extension		
	**/
 public class Request extends java.lang.Object implements java.io.Serializable
{


	/**
	* Creates a request.
	*
	* @param oid 		 the ID of the (client- or server-side) half object, which is addressed by this request.
	* @param name 		 the name of the request
	* @param arguments 		 the arguments of the request
	**/
	 public Request(int oid, java.lang.String name, com.ulcjava.base.shared.internal.Anything arguments)
	{
		 super();
	}


	/**
	* Gets the name of this request.
	*
	* @return		the name
	**/
	 public java.lang.String getName()
	{
		return null;
	}


	/**
	* Gets the ID of the (client- or server-side) half object which is addressed by
	* this request.
	*
	* @return		the ID
	**/
	 public int getOid()
	{
		return 0;
	}


	/**
	* Gets the arguments of this request.
	*
	* @return		the arguments
	**/
	 public com.ulcjava.base.shared.internal.Anything getArgs()
	{
		return null;
	}


	/**
	* Writes this request in a readable format to an output stream. (Uses {@link
	* Anything#print(boolean)} to write a corresponding string
to the stream.)
	*
	* @throws		IOException if writing to the output stream fails
	**/
	 public void dump(java.io.OutputStream out)throws java.io.IOException
	{
	}


	/**
	* Writes a sequence of requests to a ULC output stream that is created on top of
	* a data output stream. (The data output stream is not
closed after writing.)
	*
	* @param requests 		 the sequence of requests to be written
	* @param out 		 the data output stream, on which the ULC output stream is built
	* @throws		IOException if creating the ULC output stream fails or if writing fails
	**/
	 public  static void writeRequests(com.ulcjava.base.shared.internal.Request[] requests, com.ulcjava.base.shared.IObjectOutputStream out)throws java.io.IOException
	{
	}


	/**
	* Reads a sequence of requests from a ULC input stream that is created on top of
	* a data input stream. (The data input stream is not
closed after reading.)
	*
	* @param in 		 the data input stream on which the ULC input stream is built
	* @return		the sequence of read requests
	* @throws		IOException if creating the ULC input stream fails or if reading fails
	* @ulc.internal		
	**/
	 public  static com.ulcjava.base.shared.internal.Request[] readRequests(com.ulcjava.base.shared.IObjectInputStream in)throws java.io.IOException
	{
		return null;
	}


	/**
	* Returns a string representation of this request.
	*
	* @return		the string representation
	**/
	 public java.lang.String toString()
	{
		return null;
	}


}