package com.ulcjava.base.shared.internal;


	/**
	* 
	*
	* @ulc.internal		
	**/
 public  final class UlcObjectOutputStream extends java.lang.Object implements com.ulcjava.base.shared.IObjectOutputStream
{


	/**
	* Constructs a new instance. None of the arguments may be
	* null.
<p>
</p>
Implementation note: Currently, the ULC stream header is
	* written during instance construction. Invoking this constructor
	* will
thereforecause data to be written to the delegate stream.
</p>
	*
	* @param delegate 		 the output stream to which the bytes generated by this stream are written. This stream does no buffering of its own,
so it is recommended to pass a <code>BufferedOutputStream</code> as delegate.
	* @param coderRegistry 		 the {@link com.ulcjava.base.shared.CoderRegistry} used by {@link #writeObject(Object)} to obtain stream coders
for objects that are not intrinsically supported by this class (anything other than <code>String</code>s, arrays and
<code>Class</code> objects)
	**/
	 public UlcObjectOutputStream(com.ulcjava.base.shared.IDataOutputStream delegate, com.ulcjava.base.shared.CoderRegistry coderRegistry)
	{
		 super();
	}

	 public void write(int b)throws java.io.IOException
	{
	}

	 public void writeBoolean(boolean value)throws java.io.IOException
	{
	}

	 public void writeByte(byte value)throws java.io.IOException
	{
	}

	 public void writeChar(char value)throws java.io.IOException
	{
	}

	 public void writeShort(short value)throws java.io.IOException
	{
	}

	 public void writeInt(int value)throws java.io.IOException
	{
	}

	 public void writeLong(long value)throws java.io.IOException
	{
	}

	 public void writeFloat(float value)throws java.io.IOException
	{
	}

	 public void writeDouble(double value)throws java.io.IOException
	{
	}

	 public void writeUTF(java.lang.String value)throws java.io.IOException
	{
	}


	/**
	* Writes an object to this stream. The object must be read back via {@link
	* IObjectInputStream#readObject()}.
<p>
</p>
In order for an object to be
	* written by this method, one of the following must be true:
</p>
<ol>
<li>The
	* object is null. In this case, <code>readObject</code> returns
	* null.</li>
<li>The object is a string. In this case, <code>readObject</code>
	* returns a copy of the string.</li>
<li>The object is a <code>Class</code>
	* object with a defined <em>peer type</em>. In this case,
	* <code>readObject</code>
returns the <code>Class</code> object for the peer
	* type. The peer type for a given type is determined by the following
	* rules:
<ol>
<li>The peer type of a primitive type or one of the classes
	* <code>java.lang.String</code>, <code>java.lang.Class</code>
	* and
<code>java.lang.Object</code> is that type itself (incarnated in the
	* reader's VM).</li>
<li>The peer type of an array type is the array type whose
	* component type is the peer type of the original component type.</li>
<li>The
	* peer type of any other reference type is the class named by the {@link
	* IStreamCoder#getPeerClassName()} method of the
{@link IStreamCoder stream
	* coder} assigned to the original class. The peer class name is resolved
	* throughthe context classloader of
the thread calling <code>readObject</code>,
	* or, if the context classloader is null, through <code>Class.forName()</code>.
	* If no
coder has been assigned to a class, its peer type is undefined (and
	* thismethod throws an
	* <code>
IllegalArgumentException</code>).</li>
</ol>
</li><li>The object is an
	* array with a defined peer type. In this case, <code>readObject</code> returns
	* an array that is an instance of
the peer type and has the same length as the
	* original array. If the component type of the original array is primitive, the
	* elements
of the returned array are identical to the original elements.
	* Otherwise, the returned array is populated as if each array element had
been
	* transmitted separately via <code>writeObject</code> and
	* <code>readObject</code>.</li>
<li>The object is neither null, a string, a
	* class or an array, but a stream coder has been registered for its class (in
	* other words,
the object has a defined peer type). In this case, the name of
	* the object's peer type is written to the stream, and then the coder's
{@link
	* IStreamCoder#writeObject(IObjectOutputStream,Object) writeObject} method is
	* called to write the object's state to the stream.
When
	* <code>readObject</code>is invoked later, the peer class name is read and
	* resolved as described above, and then the peer class
is used to lookup the
	* appropriate coder in the reader's {@link CoderRegistry}. That coder's
{@link
	* IStreamCoder#readObject(IObjectInputStream)} method is then called to restore
	* the object from the stream, and the result of
the call becomes the result of
	* the reader's <code>readObject</code> call.</li>
</ol>
<p>
</p>
If none of
	* these conditions is satisfied, this method throws an
	* <code>IllegalArgumentException</code>.
</p>
<p>
</p>
<strong>Note:</strong>
	* This method does not provide intrinsic support for cyclic object graphs. If
	* anobject participates in a cyle,
it is the stream coder's responsibility to
	* encode the cycle in a suitable fashion.
</p>
	*
	* @param value 		 the object to write, may be null
	* @throws		IOException if the value could not be written properly.
	**/
	 public void writeObject(java.lang.Object value)throws java.io.IOException
	{
	}

	 public void flush()throws java.io.IOException
	{
	}

	 public void close()throws java.io.IOException
	{
	}


}