package com.ulcjava.base.shared.logging;


	/**
	* This is the abstract base class for log managers in ULC. It manages the logger
	* objects for an ULC application. It also provides factory
methods to access
	* thelog manager and the loggers.
	*
	* @ulc.application		
	**/
 public  abstract class LogManager extends java.lang.Object
{

	 protected LogManager()
	{
		 super();
	}


	/**
	* Gets the logger which maps to the specified name. If no logger with the
	* specified name exists, a new one will be created. The names
of loggers Can be
	* any string but should normally base on the package name.
	*
	* @param name 		 the name of the logger.
	* @return		the logger with this name.
	**/
	 public  abstract com.ulcjava.base.shared.logging.Logger getLoggerFor(java.lang.String name);

	/**
	* Gets the logger which maps to the specified name. If no logger with the
	* specified name exists, a new one will be created. The names
of loggers Can be
	* any string but should normally base on the package name.
	*
	* @param name 		 the name of the logger.
	* @return		the logger with this name.
	**/
	 public  synchronized  static com.ulcjava.base.shared.logging.Logger getLogger(java.lang.String name)
	{
		return null;
	}


	/**
	* Factory method to set the log manager of an ULC application.
	*
	* @param logManager 		 the log manager for the application.
	**/
	 public  static void setLogManager(com.ulcjava.base.shared.logging.LogManager logManager)
	{
	}


	/**
	* Factory method to get the log manager for the ULC application.
	*
	* @return		the log manager for the application.
	**/
	 public  static com.ulcjava.base.shared.logging.LogManager getLogManager()
	{
		return null;
	}


}