/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */

package com.ulcjava.environment.applet.client;

import com.ulcjava.base.client.UIFrame;
import com.ulcjava.base.shared.internal.Anything;

import javax.swing.JOptionPane;
import javax.swing.JRootPane;

public class UIAppletFrame extends UIFrame {
    private BasicFrame fFrame;
    
    protected Object createBasicObject(Anything args) {
        return JOptionPane.getFrameForComponent(AbstractAppletLauncher.getApplet());
    }
    
    public void restoreState(Anything args) {
        // Ignore all attributes because we cannot set JFrame attributes
        // here;
        // we only have a java.awt.Frame instance. We can safely ignore
        // all attributes because the frame is only artificial anyway.
    }
    
    protected void preInitializeState() {
        // Ignore all configuration.
    }
    
    protected void postInitializeState() {
        // Ignore all configuration.
    }
    
    public void handleRequest(String request, Anything args) {
        // Ignore all requests, we cannot apply any requests.
    }
    
    public void dispose() {
        // Ignore the request to dispose, we cannot dispose the basic
        // frame.
    }
    
    /**
     * Returns a dummy JRootPane. We do not have a JRootPane in a AWT frame.
     * 
     * @return a dummy root pane
     */
    public JRootPane getBasicRootPane() {
        return getDummyFrame().getRootPane();
    }
    
    /**
     * Returns a dummy BasicFrame. We do not have a BasicFrame in Applet viewers.
     * 
     * @return a dummy frame
     */
    public BasicFrame getBasicFrame() {
        return getDummyFrame();
    }
    
    private BasicFrame getDummyFrame() {
        if (fFrame == null) {
            fFrame = new BasicFrame();
        }
        return fFrame;
    }
}
