/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */

package com.ulcjava.environment.jnlp.client;

import com.ulcjava.base.client.ISessionStateListener;
import com.ulcjava.base.client.launcher.LauncherUtilities;
import com.ulcjava.base.client.launcher.ServiceFactory;
import com.ulcjava.base.shared.IClientConfiguration;
import com.ulcjava.base.shared.JdkUtilities;
import com.ulcjava.base.shared.internal.IllegalArgumentException;
import com.ulcjava.base.shared.logging.Level;
import com.ulcjava.base.shared.logging.LogManager;
import com.ulcjava.base.shared.logging.SimpleLogManager;
import com.ulcjava.container.servlet.client.AbstractRequestPropertyStore;
import com.ulcjava.container.servlet.client.CookieRequestPropertyStore;
import com.ulcjava.container.servlet.client.ServletConnector;
import com.ulcjava.container.servlet.client.SimpleRequestPropertyStore;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

/**
 * @ulc.application
 */
public class DefaultJnlpLauncher extends AbstractJnlpLauncher {
    private final IClientConfiguration fClientConfiguration;
    
    public DefaultJnlpLauncher() {
        this(null);
    }
    
    /**
     * @param clientConfiguration
     * @ulc.extension
     */
    public DefaultJnlpLauncher(IClientConfiguration clientConfiguration) {
        fClientConfiguration = clientConfiguration;
        ServiceFactory.configureServices(clientConfiguration);
    }
    
    /**
     * @ulc.extension
     */
    public static void main(String[] args) throws MalformedURLException {
        if (args.length < 1) {
            throw new IllegalArgumentException(LauncherUtilities.USAGE_TEXT);
        }
        
        Properties launcherArguments = LauncherUtilities.parseLauncherArguments(args);
        IClientConfiguration clientConfiguration = LauncherUtilities.getClientConfiguration(launcherArguments);
        
        String urlString = LauncherUtilities.getUrlString(launcherArguments);
        int keepAliveInterval = clientConfiguration.getKeepAliveInterval().intValue();
        String logLevel = clientConfiguration.getClientLogLevel();
        String dataStreamProviderClassName = clientConfiguration.getDataStreamProviderClassName();
        String carrierStreamProviderClassName = clientConfiguration.getCarrierStreamProviderClassName();
        String clientCoderRegistryProviderClassName = clientConfiguration.getClientCoderRegistryProviderClassName();
        
        LauncherUtilities.setLookAndFeel(clientConfiguration);
        
        Properties userParameters = LauncherUtilities.getUserParameters(launcherArguments);
        
        if (logLevel != null) {
            if (LogManager.getLogManager() instanceof SimpleLogManager) {
                SimpleLogManager simpleLogManager = (SimpleLogManager)LogManager.getLogManager();
                simpleLogManager.setLevel(Level.parse(logLevel));
            }
        }
        
        DefaultJnlpLauncher launcher = new DefaultJnlpLauncher(clientConfiguration);
        URL url = new URL(urlString);
        
        launcher.start(new ServletConnector(createRequestPropertyStore(url), url, keepAliveInterval, dataStreamProviderClassName,
                carrierStreamProviderClassName, clientCoderRegistryProviderClassName, clientConfiguration), userParameters);
    }
    
    private static AbstractRequestPropertyStore createRequestPropertyStore(URL url) {
        // Java Web Start provides a default CookieHandler since Java 5 so use a do nothing Cookie manager (SimpleRequestPropertyStore)
        if (JdkUtilities.isJavaVersionGreaterOrEqual(JdkUtilities.JAVA_VERSION_1_5)) {
            return new SimpleRequestPropertyStore();
        } else {
            return new CookieRequestPropertyStore(url);
        }
    }
    
    public IClientConfiguration getClientConfiguration() {
        return fClientConfiguration;
    }
    
    protected ISessionStateListener createSessionStateListener() {
        return LauncherUtilities.createSessionStateListener(getClientConfiguration());
    }
}
