/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */

package com.ulcjava.environment.standalone.client; import com.ulcjava.base.shared.internal.VersionInfo;

import com.ulcjava.base.client.ClientEnvironmentAdapter;
import com.ulcjava.base.client.IConnector;
import com.ulcjava.base.client.ISessionStateListener;
import com.ulcjava.base.client.UISession;
import com.ulcjava.base.client.launcher.DefaultSessionStateListener;
import com.ulcjava.base.client.launcher.ErrorDialog;
import com.ulcjava.base.shared.ClientEnvironmentConstants;
import com.ulcjava.base.trusted.AllPermissionsBrowserService;
import com.ulcjava.base.trusted.AllPermissionsFileService;

import java.util.Properties;

/**
 * @ulc.application
 */
public abstract class AbstractStandaloneLauncher implements ISessionStateListener { static {VersionInfo.addVersionInfo(AbstractStandaloneLauncher.class, "build.3670");}
    /**
     * @ulc.extension
     */
    public AbstractStandaloneLauncher() {
        ClientEnvironmentAdapter.setBrowserService(new AllPermissionsBrowserService());
        ClientEnvironmentAdapter.setFileService(new AllPermissionsFileService());
        ClientEnvironmentAdapter.getClientInfo().setClientEnvironmentType(ClientEnvironmentConstants.STANDALONE);
        
        UISession.setExitOnLastSessionStop(true);
    }
    
    /**
     * @ulc.extension
     */
    public UISession start(IConnector connector, Properties userParameters) {
        UISession session = new UISession(connector, userParameters);
        session.addSessionStateListener(createSessionStateListener());
        session.addSessionStateListener(this);
        session.start();
        return session;
    }
    
    /**
     * Creates an instance of {@link com.ulcjava.base.client.launcher.DefaultSessionStateListener}. Use this method to customize
     * <code>ISessionStateListener</code> implementation.
     * 
     * @ulc.extension
     */
    protected ISessionStateListener createSessionStateListener() {
        return new DefaultSessionStateListener();
    }
    
    /**
     * @ulc.extension
     * @deprecated As of ULC 6.2, use {@link #createSessionStateListener()}
     */
    public void sessionEnded(UISession session) {
    }
    
    /**
     * @ulc.extension
     * @deprecated As of ULC 6.2, use {@link #createSessionStateListener()}
     */
    public void sessionStarted(UISession session) {
    }
    
    /**
     * @ulc.extension
     * @deprecated As of ULC 6.2, use {@link #createSessionStateListener()}
     */
    public void sessionError(UISession session, Throwable reason) {
    }
    
    /**
     * @ulc.extension
     */
    public static void showMessageDialog(String windowTitle, String message, Throwable reason) {
        new ErrorDialog(windowTitle, message, reason).show();
    }
    
    /**
     * @ulc.extension
     */
    public static void showMessageDialog(String windowTitle, String message, String reason) {
        new ErrorDialog(windowTitle, message, reason).show();
    }
}
