/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

/**
 * Provides an interface for PropertyChangeSupport for its subclasses.
 */

public class AbstractBean implements Serializable {

    private PropertyChangeSupport fPcs;

    /**
     * Initializes the {@link PropertyChangeSupport}.
     */
    public AbstractBean() {
        fPcs = new PropertyChangeSupport(this);
    }

    /**
     * @see PropertyChangeSupport#addPropertyChangeListener(PropertyChangeListener)
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        fPcs.addPropertyChangeListener(listener);
    }

    /**
     * @see PropertyChangeSupport#addPropertyChangeListener(String, PropertyChangeListener)
     */
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        fPcs.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * @see PropertyChangeSupport#fireIndexedPropertyChange(String, int, boolean, boolean)
     */
    public void fireIndexedPropertyChange(String propertyName, int index, boolean oldValue, boolean newValue) {
        fPcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    /**
     * @see PropertyChangeSupport#fireIndexedPropertyChange(String, int, int, int)
     */
    public void fireIndexedPropertyChange(String propertyName, int index, int oldValue, int newValue) {
        fPcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    /**
     * @see PropertyChangeSupport#fireIndexedPropertyChange(String, int, Object, Object)
     */
    public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        fPcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    /**
     * @see PropertyChangeSupport#firePropertyChange(PropertyChangeEvent)
     */
    public void firePropertyChange(PropertyChangeEvent evt) {
        fPcs.firePropertyChange(evt);
    }

    /**
     * @see PropertyChangeSupport#firePropertyChange(String, boolean, boolean)
     */
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        fPcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    /**
     * @see PropertyChangeSupport#firePropertyChange(String, int, int)
     */
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        fPcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    /**
     * @see PropertyChangeSupport#firePropertyChange(String, Object, Object)
     */
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        fPcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    /**
     * @see PropertyChangeSupport#getPropertyChangeListeners()
     */
    public PropertyChangeListener[] getPropertyChangeListeners() {
        return fPcs.getPropertyChangeListeners();
    }

    /**
     * @see PropertyChangeSupport#getPropertyChangeListeners(String)
     */
    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return fPcs.getPropertyChangeListeners(propertyName);
    }

    /**
     * @see PropertyChangeSupport#hasListeners(String)
     */
    public boolean hasListeners(String propertyName) {
        return fPcs.hasListeners(propertyName);
    }

    /**
     * @see PropertyChangeSupport#removePropertyChangeListener(PropertyChangeListener)
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        fPcs.removePropertyChangeListener(listener);
    }

    /**
     * @see PropertyChangeSupport#removePropertyChangeListener(String, PropertyChangeListener)
     */
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        fPcs.removePropertyChangeListener(propertyName, listener);
    }


}
