/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application;

import com.ulcjava.base.application.ClientContext;

import java.io.Serializable;
import java.util.Locale;

/**
 * Provides the locale from the ULC Client context
 */
public enum ClientContextLocaleProvider implements ILocaleProvider, Serializable {
    
    INSTANCE;
    
    public static ClientContextLocaleProvider getInstance() {
        return INSTANCE;
    }
    
    
    public Locale getLocale() {
        return ClientContext.getLocale();
    }
    
}
