/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application;

import com.ulcjava.applicationframework.application.AbstractResourceConverter.ResourceConverterException;
import com.ulcjava.base.application.ULCComponent;

/**
 * Interface for classes the {@link ResourceMap} uses to convert a resource String into an object of the type needed,
 * for example to inject the properties into a {@link ULCComponent}.
 * 
 * @param <T> The generic type representing the type to which a resource is converted to.
 */
public interface IResourceConverter<T> {
    /**
     * Parses the given String and converts it into an object of the type returned by getType().
     * 
     * @param s the String to parse.
     * @param r the resourceMap the conversion is made for.
     * @return the object created with the given string.
     * @throws ResourceConverterException
     */
    public T parseString(String s, ResourceMap r) throws ResourceConverterException;

    /**
     * @return the type into which Strings are converted.
     */
    public Class<T> getType();

}