/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.binding;

import com.ulcjava.applicationframework.application.form.model.FormModel;
import com.ulcjava.base.application.ULCComponent;

/**
 * Base class for {@link IFormModelBinding}s that are working with a {@code ULCComponent}.
 * 
 * @param <T> The generic type representing the type of the widget
 */
public abstract class AbstractWidgetBinder<T extends ULCComponent> implements IFormModelBinding {

    private final String fPropertyName;
    private final T fWidget;
    private FormModel<?> fModel;

    /**
     * Creates a binding between the given {@link ULCComponent} and the given property.
     * 
     * @param model that holds the property. Must not be <code>null</code>.
     * @param propertyName name of the property to be bound. Must not be <code>null</code>.
     * @param widget to be bound. Must not be <code>null</code>.
     * @throws IllegalArgumentException if any of the parameter is <code>null</code>.
     */
    public AbstractWidgetBinder(FormModel<?> model, String propertyName, T widget) {
        if (model == null) {
            throw new IllegalArgumentException("widgetBinderManager must not be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName must not be null");
        }
        if (widget == null) {
            throw new IllegalArgumentException("widget must not be null");
        }

        fModel = model;
        fPropertyName = propertyName;
        fWidget = widget;
    }

    public final void detachFromModel(FormModel<?> model) {
        if (model == null) {
            throw new IllegalArgumentException("Model must not be null");
        }
        fModel = null;
    }

    public final void attachToModel(FormModel<?> model) {
        if (model == null) {
            throw new IllegalArgumentException("Model must not be null");
        }
        fModel = model;
        updateValueFromModel(model);
    }

    /**
     * @return the name of the property that is bound.
     */
    protected String getPropertyName() {
        return fPropertyName;
    }

    /**
     * @return the {@link ULCComponent} that is bound.
     */
    protected T getWidget() {
        return fWidget;
    }

    /**
     * @return the form model that holds the bound property.
     */
    protected FormModel<?> getModel() {
        return fModel;
    }

}