/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.binding;

import com.ulcjava.applicationframework.application.form.model.FormModel;

import java.io.Serializable;

public interface IFormModelBinding extends Serializable {

    /**
     * Binds property change listener to the model.
     * 
     * @param model the model that gets bound.
     */
    public void attachToModel(FormModel<?> model);

    /**
     * Unbinds all property change listener from the model.
     * 
     * @param model the model that gets unbound.
     */
    public void detachFromModel(FormModel<?> model);

    /**
     * Updates the value from the model into the from.
     * 
     * @param model the model to take the value from.
     */
    public void updateValueFromModel(FormModel<?> model);
}
