/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.binding;

import java.io.Serializable;

/**
 * Interface for objects that receive a value and know how to update the (form) view with this new value.
 */
public interface IViewUpdater extends Serializable {
    /**
     * Update the view according to <code>newValue</code>.
     * 
     * @param newValue the value to be displayed.
     */
    public void updateView(Object newValue);

}
