/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.binding;

import com.ulcjava.applicationframework.application.form.model.FormModel;
import com.ulcjava.applicationframework.application.form.model.PropertyAccessException;
import com.ulcjava.applicationframework.application.form.model.SetPropertyCommand;
import com.ulcjava.base.application.ULCList;
import com.ulcjava.base.application.event.IListSelectionListener;
import com.ulcjava.base.application.event.ListSelectionEvent;

/**
 * Binds a {@link ULCList} to a {@link FormModel} property.
 */
public class ListBinder extends AbstractWidgetBinder<ULCList> implements IFormModelBinding {
    /**
     * Creates a binding between the given {@link ULCList} and the given property.
     * 
     * @param model that holds the property. Must not be <code>null</code>.
     * @param propertyName name of the property to be bound. Must not be <code>null</code>.
     * @param list to be bound. Must not be <code>null</code>.
     */
    public ListBinder(FormModel<?> model, String propertyName, ULCList list) {
        super(model, propertyName, list);
        list.getSelectionModel().addListSelectionListener(new IListSelectionListener() {

            public void valueChanged(ListSelectionEvent event) {
                try {
                    Object selectedValue = getList().getSelectedValue();
                    getModel().setProperty(new SetPropertyCommand(getPropertyName(), selectedValue));
                } catch (PropertyAccessException e) {
                    throw new RuntimeException(e);
                }
            }

        });
    }

    /**
     * Updates the list if the property's value is not equal to the list's selected value.
     */
    public void updateValueFromModel(FormModel<?> model) {
        try {
            Object value = model.getProperty(getPropertyName());
            Object selectedValue = getList().getSelectedValue();
            if (!((selectedValue != null) && selectedValue.equals(value))
                    || ((selectedValue == null) && (value != null))) {
                getList().setSelectedValue(value, true);
            }
        } catch (PropertyAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * @return the {@link ULCList} that is bound.
     */
    protected ULCList getList() {
        return getWidget();
    }

}
