/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.binding;

import com.ulcjava.applicationframework.application.form.model.FormModel;
import com.ulcjava.applicationframework.application.form.model.PropertyAccessException;
import com.ulcjava.applicationframework.application.form.model.SetPropertyCommand;
import com.ulcjava.base.application.ULCSlider;
import com.ulcjava.base.application.event.IValueChangedListener;
import com.ulcjava.base.application.event.ValueChangedEvent;

/**
 * Binds a {@link ULCSlider} to a {@link FormModel} property.
 */
public class SliderBinder extends AbstractWidgetBinder<ULCSlider> {

    /**
     * Creates a binding between the given {@link ULCSlider} and the given property.
     * 
     * @param model that holds the property. Must not be <code>null</code>.
     * @param propertyName name of the property to be bound. Must not be <code>null</code>.
     * @param slider to be bound. Must not be <code>null</code>.
     */
    public SliderBinder(FormModel<?> model, String propertyName, ULCSlider slider) {
        super(model, propertyName, slider);

        IValueChangedListener valueChangedListener = new IValueChangedListener() {

            public void valueChanged(ValueChangedEvent event) {
                try {
                    Object value = new Integer(getULCSlider().getValue());
                    if (value != null) {
                        getModel().setProperty(new SetPropertyCommand(getPropertyName(), value));
                    }
                } catch (PropertyAccessException e) {
                    throw new RuntimeException(e);
                }
            }

        };
        getULCSlider().addValueChangedListener(valueChangedListener);
    }

    /**
     * @return the {@link ULCSlider} that is bound.
     */
    protected ULCSlider getULCSlider() {
        return getWidget();
    }

    public void updateValueFromModel(FormModel<?> model) {
        try {
            Object value = model.getProperty(getPropertyName());
            if (value instanceof Number) {
                getULCSlider().setValue(((Number)value).intValue());
            }
        } catch (PropertyAccessException e) {
            throw new RuntimeException(e);
        }
    }

}
