/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.binding;

import com.ulcjava.applicationframework.application.form.model.FormModel;
import com.ulcjava.applicationframework.application.form.model.PropertyAccessException;
import com.ulcjava.applicationframework.application.form.model.SetPropertyCommand;
import com.ulcjava.base.application.ULCTextArea;
import com.ulcjava.base.application.event.IValueChangedListener;
import com.ulcjava.base.application.event.ValueChangedEvent;

/**
 * Binds a {@link ULCTextArea} to a {@link FormModel} property.
 */
public class TextAreaBinder extends AbstractWidgetBinder<ULCTextArea> implements IFormModelBinding {

    /**
     * Creates a binding between the given {@link ULCTextArea} and the given property.
     * 
     * @param model that holds the property. Must not be <code>null</code>.
     * @param propertyName name of the property to be bound. Must not be <code>null</code>.
     * @param textArea to be bound. Must not be <code>null</code>.
     */
    public TextAreaBinder(FormModel<?> model, final String propertyName, final ULCTextArea textArea) {
        super(model, propertyName, textArea);
        getTextArea().addValueChangedListener(new IValueChangedListener() {

            public void valueChanged(ValueChangedEvent event) {
                try {
                    getModel().setProperty(new SetPropertyCommand(getPropertyName(), getTextArea().getText()));
                } catch (PropertyAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    /**
     * @return the {@link ULCTextArea} that is bound.
     */
    protected ULCTextArea getTextArea() {
        return getWidget();
    }

    public void updateValueFromModel(FormModel<?> model) {
        try {
            getTextArea().setText((String)model.getProperty(getPropertyName()));
        } catch (PropertyAccessException e) {
            throw new RuntimeException(e);
        }
    }

}