/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.binding.table;

import java.io.Serializable;
import java.util.EventListener;
import java.util.List;

/**
 * <code>ObservableListListener</code>s are notified when an <code>ObservableList</code>'s data changes.
 * <p>
 * </p>
 * <b>Features</b>
 * <ul>
 * <li><code>ObservableListListener</code>s can be registered with an <code>ObservabelList</code> to be notified
 * when the list's data changes.
 * <li>For each type of change (element added, removed, or replaced) a separate method is called.
 * </ul>
 * 
 * @see com.ulcjava.applicationframework.application.binding.table.ObservableList
 * @see com.ulcjava.applicationframework.application.binding.table.ObservableCollections
 * @param <T> The formal type parameter for the elements contained in the list.
 */
public interface ObservableListListener<T> extends EventListener, Serializable {
    /**
     * This method is called when an element or elements are added to the <code>ObservableList</code>.
     * 
     * @param list The <code>ObservableList</code> instance.
     * @param index The start index of the element(s) that is/are added.
     * @param length The number of the elements that are added.
     */
    public void listElementsAdded(ObservableList<T> list, int index, int length);

    /**
     * This method is called when an element or elements are removed from the <code>ObservableList</code>.
     * 
     * @param list The <code>ObservableList</code> instance.
     * @param index The start index of the element(a) that is/are removed.
     * @param oldElements The list of the removed elements.
     */
    public void listElementsRemoved(ObservableList<T> list, int index, List<T> oldElements);

    /**
     * This method is called when an element is replaced in the <code>ObservableList</code>.
     * 
     * @param list The <code>ObservableList</code> instance.
     * @param index The index of the replaced element.
     * @param oldElement The element that is replaced.
     */
    public void listElementReplaced(ObservableList<T> list, int index, T oldElement);
}
