/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.form;

import com.ulcjava.base.application.ULCCheckBox;

/**
 * Helper class that is used by the {@link AbstractFormBuilder} to collect the parameters for a {@link ULCCheckBox} that
 * is added to the form. Holds the parameters to configure the checkbox such as:
 * <dl>
 * <dt>text</dt>
 * <dd>Sets the text that is shown after the checkbox. The default is <code>null</code>.</dd>
 * </dl>
 */
public class CheckboxParameter extends LayoutParameter<CheckboxParameter, ULCCheckBox, WidgetFactory> {
    /**
     * Creates a {@code CheckboxParameter} object for the given property that uses the given WidgetFactory to create the
     * {@link ULCCheckBox}.
     * 
     * @param propertyName name of the property the checkbox is bound to.
     * @param widgetFactory factory that is used to create widgets. Must not be <code>null</code>.
     */
    public CheckboxParameter(String propertyName, WidgetFactory widgetFactory) {
        super(propertyName, widgetFactory);
    }

    /**
     * @return <code>this</code>.
     */
    @Override
    protected CheckboxParameter getThis() {
        return this;
    }

    /**
     * @return the text of the checkbox.
     */
    public String getText() {
        return getWidget().getText();
    }

    /**
     * Sets the text on the checkBox. The text is shown after the checkbox.
     * 
     * @param textAfter the text to set on checkbox.
     * @return the CheckboxParameter object itself.
     */
    public CheckboxParameter text(String textAfter) {
        getWidget().setText(textAfter);
        return this;
    }

    /**
     * Creates a {@link ULCCheckBox} with the {@link WidgetFactory}.
     * 
     * @return the created checkbox.
     */
    @Override
    protected ULCCheckBox createWidget() {
        return getWidgetFactory().createCheckBox();
    }


}