/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.form;

import com.ulcjava.base.application.IComboBoxModel;
import com.ulcjava.base.application.ULCComboBox;

/**
 * Helper class that is used by the {@link AbstractFormBuilder} to collect the parameters for a {@link ULCComboBox} that
 * is added to the form. Holds the parameters to configure the combobox, such as:
 * <dl>
 * <dt>editable</dt>
 * <dd>Sets the editable flag of the {@link ULCComboBox}. If true this allows to enter text additionally to selecting
 * an entry. The default is <code>false</code>. </dd>
 * </dl>
 * 
 * @see ULCComboBox
 */
public class ComboboxParameter extends LayoutParameter<ComboboxParameter, ULCComboBox, WidgetFactory> {
    /**
     * Creates a ComboboxParameter object for the given property that uses the given WidgetFactory to create the
     * {@link ULCComboBox}.
     * 
     * @param propertyName name of the property the combobox is bound to.
     * @param model that defines the combobox's entries.
     * @param widgetFactory factory that is used to create widgets. Must not be <code>null</code>.
     */
    public ComboboxParameter(String propertyName, IComboBoxModel model, WidgetFactory widgetFactory) {
        super(propertyName, widgetFactory);
        getWidget().setModel(model);
        editable(false);
    }

    /**
     * @return <code>this</code>.
     */
    @Override
    protected ComboboxParameter getThis() {
        return this;
    }

    /**
     * @return the value of the comobox's editable flag.
     */
    public boolean isEditable() {
        return getWidget().isEditable();
    }

    /**
     * Sets the combobox's editable flag.
     * 
     * @param isEditable value that is set.
     * @return the ComboboxParameter object itself.
     */
    public ComboboxParameter editable(boolean isEditable) {
        getWidget().setEditable(isEditable);
        return this;
    }

    /**
     * Creates a {@link ULCComboBox} with the {@link WidgetFactory}.
     * 
     * @return the created combobox.
     */
    @Override
    protected ULCComboBox createWidget() {
        return getWidgetFactory().createComboBox();
    }
}