/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.form;

import com.ulcjava.base.application.ULCComponent;

/**
 * Helper class that is used by the {@link AbstractFormBuilder} to collect the parameters for an unbound widget that is
 * added to the form.
 */
public class GeneralParameter extends LayoutParameter<GeneralParameter, ULCComponent, WidgetFactory> {

    /**
     * Creates a GeneralParameter object with the given widget.
     * 
     * @param widget that is added to the form.
     * @param widgetFactory factory that is used to create widgets. Must not be <code>null</code>.
     */
    public GeneralParameter(ULCComponent widget, WidgetFactory widgetFactory) {
        super(widget, widgetFactory);
    }

    /**
     * @return <code>this</code>.
     */
    @Override
    protected GeneralParameter getThis() {
        return this;
    }

    /**
     * Does not create a new widget but returns the widget that was passed in to the constructor.
     * 
     * @return the widget that was passed in to the constructor
     */
    @Override
    protected ULCComponent createWidget() {
        return getWidget();
    }


}
