/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.form;

import com.ulcjava.base.application.IListModel;
import com.ulcjava.base.application.ULCList;

/**
 * Helper class that is used by the {@link AbstractFormBuilder} to collect the parameters for a {@link ULCList} that is
 * added to the form. The list model is passed to the constructor.
 */
public class ListParameter extends LayoutParameter<ListParameter, ULCList, WidgetFactory> {
    /**
     * Creates a ListParameter object for the given property that uses the given WidgetFactory to create the
     * {@link ULCList}.
     * 
     * @param propertyName name of the property the list is bound to.
     * @param model {@code IListModel} that defines the list's entries.
     * @param widgetFactory factory that is used to create widgets. Must not be <code>null</code>.
     */
    public ListParameter(String propertyName, IListModel model, WidgetFactory widgetFactory) {
        super(propertyName, widgetFactory);
        getWidget().setModel(model);
    }

    /**
     * Creates a {@code ULCList} with the {@link WidgetFactory}.
     * 
     * @return the created {@code ULCList}.
     */
    @Override
    protected ULCList createWidget() {
        ULCList list = getWidgetFactory().createList();
        if (getPropertyName() != null) {
            list.setName(getPropertyName() + ".List");
        }
        return list;
    }

    /**
     * returns <code>this</code>.
     */
    @Override
    protected ListParameter getThis() {
        return this;
    }
}
