/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.form;

import com.ulcjava.base.application.ULCSpinner;
import com.ulcjava.base.application.ULCSpinnerListModel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Helper class that is used by the {@link AbstractFormBuilder} to collect the parameters for a {@link ULCSpinner} with
 * a list model that is added to the form.
 * 
 * @see ULCSpinner
 * @see ULCSpinnerListModel
 */
public class ListSpinnerParameter extends LayoutParameter<ListSpinnerParameter, ULCSpinner, WidgetFactory> {
    private ULCSpinnerListModel fSpinnerModel;

    /**
     * Creates a {@code ListSpinnerParameter} object for the given property that uses the given {@code WidgetFactory} to
     * create the {@link ULCSpinner}.
     * 
     * @param propertyName name of the property the spinner is bound to.
     * @param list that defines the spinner's entries.
     * @param widgetFactory factory that is used to create widgets. Must not be <code>null</code>.
     */
    public ListSpinnerParameter(String propertyName, WidgetFactory widgetFactory, Object[] list) {
        this(propertyName, widgetFactory, Arrays.asList(list));
    }

    /**
     * Creates a {@code ListSpinnerParameter} object for the given property that uses the given {@code WidgetFactory} to
     * create the {@link ULCSpinner}.
     * 
     * @param propertyName name of the property the spinner is bound to.
     * @param list that defines the spinner's entries.
     * @param widgetFactory factory that is used to create widgets. Must not be <code>null</code>.
     */
    public ListSpinnerParameter(String propertyName, WidgetFactory widgetFactory, List<?> list) {
        super(propertyName, widgetFactory);
        list(list);
    }

    /**
     * @return <code>this</code>.
     */
    @Override
    protected ListSpinnerParameter getThis() {
        return this;
    }

    private ListSpinnerParameter list(List<?> list) {
        fSpinnerModel.setList(new ArrayList(list));
        return this;
    }

    /**
     * Creates a {@link ULCSpinner} with the {@link WidgetFactory} and sets a {@link ULCSpinnerListModel} on it.
     * 
     * @return the created {@code ULCSpinner}.
     */
    @Override
    protected ULCSpinner createWidget() {
        fSpinnerModel = new ULCSpinnerListModel();
        ULCSpinner spinner = getWidgetFactory().createSpinner();
        spinner.setModel(fSpinnerModel);
        return spinner;
    }
}