/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.form;

import com.ulcjava.base.application.ULCBoxPane;
import com.ulcjava.base.application.ULCButtonGroup;
import com.ulcjava.base.application.ULCCheckBox;
import com.ulcjava.base.application.ULCComboBox;
import com.ulcjava.base.application.ULCLabel;
import com.ulcjava.base.application.ULCList;
import com.ulcjava.base.application.ULCListSelectionModel;
import com.ulcjava.base.application.ULCPasswordField;
import com.ulcjava.base.application.ULCRadioButton;
import com.ulcjava.base.application.ULCSlider;
import com.ulcjava.base.application.ULCSpinner;
import com.ulcjava.base.application.ULCTextArea;
import com.ulcjava.base.application.ULCTextField;

import java.io.Serializable;

/**
 * This class is used by the form bean widget creation to produce instances of the widgets. This factory uses the
 * default constructor to create the instances. This class is meant to be subclassed to work with a set of subclasses of
 * the ULCComponents (e.g. ACMETextField, ACMESpinner...)
 */
public class WidgetFactory implements Serializable {
    /**
     * @return a {@link ULCCheckBox}
     */
    public ULCCheckBox createCheckBox() {
        return new ULCCheckBox();
    }

    /**
     * @return a {@link ULCComboBox}
     */
    public ULCComboBox createComboBox() {
        return new ULCComboBox();
    }

    /**
     * @return a {@link ULCButtonGroup}
     */
    public ULCButtonGroup createButtonGroup() {
        return new ULCButtonGroup();
    }

    /**
     * @return a {@link ULCRadioButton}
     */
    public ULCRadioButton createRadioButton() {
        return new ULCRadioButton();
    }

    /**
     * @return a {@link ULCLabel}
     */
    public ULCLabel createLabel() {
        return new ULCLabel();
    }

    /**
     * @return a {@link ULCSpinner}
     */
    public ULCSpinner createSpinner() {
        return new ULCSpinner();
    }

    /**
     * @return a {@link ULCSlider}
     */
    public ULCSlider createSlider() {
        return new ULCSlider();
    }

    /**
     * @return a {@link ULCPasswordField}
     */
    public ULCPasswordField createPasswordField() {
        return new ULCPasswordField();
    }

    /**
     * @return a {@link ULCTextField}
     */
    public ULCTextField createTextField() {
        return new ULCTextField();
    }

    /**
     * @return a {@link ULCTextArea}
     */
    public ULCTextArea createTextArea() {
        return new ULCTextArea();
    }

    /**
     * @return a {@link ULCBoxPane}
     */
    public ULCBoxPane createBoxPane() {
        return new ULCBoxPane();
    }

    /**
     * @return a {@link ULCList}
     */
    public ULCList createList() {
        ULCList list = new ULCList();
        list.setSelectionMode(ULCListSelectionModel.SINGLE_SELECTION);
        return list;
    }
}
