/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.form.model;

import com.ulcjava.applicationframework.application.binding.table.TableBinding;

/**
 * Thrown by the {@link FormModel} and the {@link TableBinding} to indicate that the access to a property on the wrapped
 * bean has failed.
 */
public class PropertyAccessException extends RuntimeException {

    /**
     * @param message information about the kind of error
     * @param root the Exception causing the failure
     */
    public PropertyAccessException(String message, Exception root) {
        super(message, root);
    }

    /**
     * Create an instance of {@code PropertyAccessException}
     * 
     * @param message the detailed meesage for the exception
     */
    public PropertyAccessException(String message) {
        this(message, null);
    }

}
