package com.ulcjava.base.application;


	/**
	* This is the base class for the concrete column classes.
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.table.ULCTableColumn
	* @see		com.ulcjava.base.application.tabletree.ULCTableTreeColumn
	**/
 public  abstract class AbstractColumn extends com.ulcjava.base.application.ULCProxy
{

	 protected void uploadStateUI()
	{
	}

	 protected void updatePreferredWidth(int preferredWidth)
	{
	}

	 protected void updateWidth(int width)
	{
	}

	 protected AbstractColumn(int modelIndex, int width)
	{
		 super();
	}


	/**
	* Returns the <code>Object</code> used as the value for the header renderer.
	*
	* @return		the <code>headerValue</code> property
	* @see		#setHeaderValue
	**/
	 public java.lang.Object getHeaderValue()
	{
		return null;
	}


	/**
	* Returns the <code>identifier</code> object for this column. Note: Identifiers
	* are not used by the underlying widget, component,
they are purely a
	* convenience for external use. If the <code>identifier</code> is
	* <code>null</code>,
<code>getIdentifier()</code> returns
	* <code>getHeaderValue</code> as a default.
	*
	* @return		the <code>identifier</code> property
	* @see		#setIdentifier
	**/
	 public java.lang.Object getIdentifier()
	{
		return null;
	}


	/**
	* Returns the maximum width for the column. The column's width can't be made
	* larger than this either by the user or programmatically.
The default maxWidth
	* is Integer.MAX_VALUE.
	*
	* @return		the <code>maxWidth</code> property
	* @see		#setMaxWidth
	**/
	 public int getMaxWidth()
	{
		return 0;
	}


	/**
	* Returns the minimum width for the column. The column's width can't be made
	* lessthan this either by the user or programmatically. The
default minWidth is
	* 15.
	*
	* @return		the <code>minWidth</code> property
	* @see		#setMinWidth
	**/
	 public int getMinWidth()
	{
		return 0;
	}


	/**
	* Returns the model index for this column.
	*
	* @return		the <code>modelIndex</code> property
	**/
	 public int getModelIndex()
	{
		return 0;
	}


	/**
	* Returns the preferred width of this column. The default preferred width is 75.
	*
	* @return		the <code>preferredWidth</code> property
	* @see		#setPreferredWidth
	**/
	 public int getPreferredWidth()
	{
		return 0;
	}


	/**
	* Returns true if the user is allowed to resize the column's width, false
	* otherwise. You can change the width programmatically
regardless of this
	* setting. The default is true.
	*
	* @return		the <code>isResizable</code> property
	* @see		#setResizable
	**/
	 public boolean getResizable()
	{
		return false;
	}


	/**
	* Returns the width of the column. The default width is 75.
<p>
</p>
Note that
	* ifthe <code>preferredWidth</code>, <code>minWidth</code>,
	* <code>maxWidth</code> properties of this or any other
column is changed, the
	* <code>width</code> property is only updated with the next server roundtrip.
	*
	* @return		the <code>width</code> property
	**/
	 public int getWidth()
	{
		return 0;
	}


	/**
	* Sets the <code>Object</code> whose string representation will be used as the
	* value for the <code>headerRenderer</code>. When the
column is created, the
	* default <code>headerValue</code> is <code>null</code>.
	*
	* @param headerValue 		 the new headerValue
	* @see		#getHeaderValue
	**/
	 public void setHeaderValue(java.lang.Object headerValue)
	{
	}


	/**
	* Sets the column's identifier to <code>identifier</code>.
<p>
Note: Identifiers
	* are not used by the underlying widget, they are purely a convenience for the
	* external tagging and location of
columns.
	*
	* @param identifier 		 an identifier for this column
	* @see		#getIdentifier
	**/
	 public void setIdentifier(java.lang.Object identifier)
	{
	}


	/**
	* Sets the column's maximum width to <code>maxWidth</code>; also adjusts the
	* width and preferred width if they are greater than this
value.
	*
	* @param maxWidth 		 the new maximum width
	* @see		#getMaxWidth
	* @see		#setPreferredWidth
	* @see		#setMinWidth
	**/
	 public void setMaxWidth(int maxWidth)
	{
	}


	/**
	* Sets the column's minimum width to <code>minWidth</code>; also adjusts the
	* current width and preferred width if they are less than
this value.
	*
	* @param minWidth 		 the new minimum width
	* @see		#getMinWidth
	* @see		#setPreferredWidth
	* @see		#setMaxWidth
	**/
	 public void setMinWidth(int minWidth)
	{
	}


	/**
	* Sets the model index for this column. The model index is the index of the
	* column in the model that will be displayed by this column.
As the column is
	* moved around in the view the model index remains constant.
	*
	* @param modelIndex 		 the new modelIndex
	**/
	 public void setModelIndex(int modelIndex)
	{
	}


	/**
	* Sets this column's preferred width to <code>preferredWidth</code>. If
	* <code>preferredWidth</code> exceeds the minimum or maximum
width, it is
	* adjusted to the appropriate limiting value.
<p>
</p>
	*
	* @param preferredWidth 		 the new preferred width
	* @see		#getPreferredWidth
	**/
	 public void setPreferredWidth(int preferredWidth)
	{
	}


	/**
	* Sets whether this column can be resized.
	*
	* @param isResizable 		 if true, resizing is allowed; otherwise false
	* @see		#getResizable
	**/
	 public void setResizable(boolean isResizable)
	{
	}


	/**
	* Resizes the column to fit the width of its header cell. This method does
	* nothing if the header renderer is <code>null</code> (the
default case).
	*
	* @see		#setPreferredWidth
	**/
	 public void sizeWidthToFit()
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class AbstractColumnDispatcher extends ULCProxyDispatcher
{

	 public  final void updatePreferredWidth(int preferredWidth)
	{
	}

	 public  final void updateWidth(int width)
	{
	}


}
}