package com.ulcjava.base.application;


	/**
	* The <code>AbstractListModel</code> provides an abstract implementation for the
	* <code>IListModel</code>.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>AbstractListModel</code> keeps track of the listeners of the model,
	* added and removed via
<code>addListDataListener</code> and
	* <code>removeListDataListener</code>.
<li>It provides methods to notify the
	* registered listeners about changes the model.
</ul>
	*
	* @ulc.application		
	* @see		ULCList
	* @see		IListModel
	* @see		com.ulcjava.base.application.event.IListDataListener
	**/
 public  abstract class AbstractListModel extends java.lang.Object implements com.ulcjava.base.application.IListModel, java.io.Serializable
{

	 protected AbstractListModel()
	{
		 super();
	}

	 public void addListDataListener(com.ulcjava.base.application.event.IListDataListener listener)
	{
	}

	 public void removeListDataListener(com.ulcjava.base.application.event.IListDataListener listener)
	{
	}


	/**
	* Returns an array of all the list data listeners registered on this
	* <code>AbstractListModel</code>.
	*
	* @return		all of this model's <code>IListDataListener</code>s, or an empty array if no list data listeners are currently registered
	* @see		#addListDataListener(IListDataListener)
	* @see		#removeListDataListener(IListDataListener)
	**/
	 public com.ulcjava.base.application.event.IListDataListener[] getListDataListeners()
	{
		return null;
	}


	/**
	* Notifies all listeners that one or more elements of the list have changed. The
	* changed elements are in the closed interval from
index0 to
	* index1.
<p>
</p>
Note that the elements in the given interval must already
	* exist. Do not use this method to notify about the addition or insertion
	* of
newelements but use <code>fireIntervalAdded()</code> instead.
	*
	* @param source 		 the list model that changed
	* @param index0 		 the lower end of the changed interval
	* @param index1 		 the upper end of changed interval
	**/
	 public void fireContentsChanged(java.lang.Object source, int index0, int index1)
	{
	}


	/**
	* Notifies all listeners that one or more elements have been added to or
	* insertedinto the model. The new elements are in the closed
interval from
	* index0 to index1.
	*
	* @param source 		 the list model that changed
	* @param index0 		 the lower end of the interval of the new elements
	* @param index1 		 the upper end of the interval of the new elements
	**/
	 public void fireIntervalAdded(java.lang.Object source, int index0, int index1)
	{
	}


	/**
	* Notifies all listeners that one or more elements have been removed from the
	* model. The removed elements were in the closed interval
from index0 to index1.
	*
	* @param source 		 the list model that changed
	* @param index0 		 the lower end of the removed interval
	* @param index1 		 the upper end of the removed interval
	**/
	 public void fireIntervalRemoved(java.lang.Object source, int index0, int index1)
	{
	}


}