package com.ulcjava.base.application;


	/**
	* The <code>ApplicationContext</code> class provides access to the application's
	* runtime environment. ULC applications can use this class
to access the
	* environment in a container-independent way. Note that although all methods
	* arestatic, the ULC framework takes care of
looking up the current application
	* instance.
	*
	* @ulc.application		
	**/
 public class ApplicationContext extends java.lang.Object
{

	/**
	* The code that denotes that the server container type is not set properly and
	* therefore undefined
	*
	* @see		#getServerContainerType
	**/
	 public  final  static int UNDEFINED = 0;

	/**
	* The code that denotes the application is deployed in a Servlet container
	*
	* @see		#getServerContainerType
	**/
	 public  final  static int SERVLET = 0;

	/**
	* The code that denotes the application is deployed in an EJB container
	*
	* @see		#getServerContainerType
	**/
	 public  final  static int EJB = 0;

	/**
	* The code that denotes the application is deployed in a Local container
	*
	* @see		#getServerContainerType
	**/
	 public  final  static int LOCAL = 0;

	/**
	* The code that denotes the application is deployed in a Development container
	*
	* @see		#getServerContainerType
	**/
	 public  final  static int DEVELOPMENT = 0;

	 private ApplicationContext()
	{
		 super();
	}


	/**
	* Terminates the currently running application.
	*
	**/
	 public  static void terminate()
	{
	}


	/**
	* Returns a <code>Principal</code> object containing the name of the current
	* authenticated user (optional operation). If the user has
not been
	* authenticated, the method returns null. This methods forwards the call to the
	* server container.
	*
	* @return		a <code>Principal</code> containing the name of the user making this request; null if the user has not been authenticated
	* @throws		UnsupportedOperationException if the <code>getUserPrincipal</code> method is not supported by the server container.
	* @see		Principal
	**/
	 public  static java.security.Principal getUserPrincipal()
	{
		return null;
	}


	/**
	* Returns a boolean indicating whether the authenticated user is included in the
	* specified logical "role" (optional operation). If the
user has not been
	* authenticated, the method returns false. This methods forwards the call to
	* theserver container.
	*
	* @param role 		 a String specifying the name of the role
	* @return		a boolean indicating whether the user making this request belongs to a given role; false if the user has not been
authenticated
	* @throws		UnsupportedOperationException if the <code>getUserPrincipal</code> method is not supported by the server container.
	**/
	 public  static boolean isUserInRole(java.lang.String role)
	{
		return false;
	}


	/**
	* Returns the names of all init parameters. This methods forwards the call to
	* theserver container.
	*
	* @return		the names of all init parameters
	**/
	 public  static java.lang.String[] getInitParameterNames()
	{
		return null;
	}


	/**
	* Returns the init parameter indicated by the specified key. This methods
	* forwards the call to the server container.
	*
	* @param key 		 the name of the init parameter
	* @return		the string value of the init parameter, or <code>null</code> if there is no init parameter with that key
	**/
	 public  static java.lang.String getInitParameter(java.lang.String key)
	{
		return null;
	}


	/**
	* Returns the code denoting the server container type.
	*
	* @return		the code denoting the server container type
	**/
	 public  static int getServerContainerType()
	{
		return 0;
	}


	/**
	* Returns the names of all application attributes.
	*
	* @return		the names of all application attributes
	**/
	 public  static java.lang.String[] getAttributeNames()
	{
		return null;
	}


	/**
	* Returns the application attribute indicated by the specified key.
	*
	* @param key 		 the name of the application attribute
	* @return		the application attribute, or <code>null</code> if there is no application attribute with that key
	**/
	 public  static java.lang.Object getAttribute(java.lang.String key)
	{
		return null;
	}


	/**
	* Sets the application attribute indicated by the specified key. The attribute
	* isadded non-transient and thus will be serialized
whenever the
	* <code>ULCSession</code> is serialized (e.g. during session replication).
	*
	* @param key 		 the name of the application attribute
	* @param value 		 the new value of the application attribute
	* @see		#setAttribute(String, Object, boolean)
	**/
	 public  static void setAttribute(java.lang.String key, java.lang.Object value)
	{
	}


	/**
	* Sets the application attribute indicated by the specified key. If
	* <code>isTransient</code> is <code>false</code>, the attribute
is added
	* non-transient and thus will be serialized whenever the
	* <code>ULCSession</code>is serialized (e.g. during session
replication). If
	* <code>isTransient</code> is <code>true</code>, the attribute is added
	* transient and thus will not be serialized
whenever the
	* <code>ULCSession</code>is serialized. Therefore, the attribute no longer
	* exists in the deserialized instance of
<code>ULCSession</code> and must be
	* re-registered with the <code>ULCSession</code> manually.
	*
	* @param key 		 the name of the application attribute
	* @param value 		 the new value of the application attribute
	* @param isTransient 		 true if the attribute is transient, false if the attribute is persistent
	**/
	 public  static void setAttribute(java.lang.String key, java.lang.Object value, boolean isTransient)
	{
	}


	/**
	* Removes the application attribute indicated by the specified key.
	*
	* @param key 		 the name of the application attribute
	**/
	 public  static void removeAttribute(java.lang.String key)
	{
	}


	/**
	* This method adds a round trip listener.
	*
	* @param listener 		 the listener to add
	**/
	 public  static void addRoundTripListener(com.ulcjava.base.application.event.IRoundTripListener listener)
	{
	}


	/**
	* This method removes a round trip listener.
	*
	* @param listener 		 the listener to remove
	**/
	 public  static void removeRoundTripListener(com.ulcjava.base.application.event.IRoundTripListener listener)
	{
	}


	/**
	* Returns an array of all the round trip listeners registered on the current
	* session.
	*
	* @return		all of this current session's <code>IRoundTripListener</code>s or an empty array if no round trip listeners are currently
registered
	* @see		#addRoundTripListener(IRoundTripListener)
	* @see		#removeRoundTripListener(IRoundTripListener)
	**/
	 public  static com.ulcjava.base.application.event.IRoundTripListener[] getRoundTripListeners()
	{
		return null;
	}


	/**
	* Returns the actual application instance.
	*
	* @return		the actual application instance.
	**/
	 public  static com.ulcjava.base.application.IApplication getApplication()
	{
		return null;
	}


	/**
	* Returns the title of the implementation.
	*
	* @return		the title of the implementation
	**/
	 public  static java.lang.String getImplementationTitle()
	{
		return null;
	}


	/**
	* Returns the vendor of the implementation.
	*
	* @return		the vendor of the implementation
	**/
	 public  static java.lang.String getImplementationVendor()
	{
		return null;
	}


	/**
	* Returns the implementation version.
	*
	* @return		the implementation version
	**/
	 public  static java.lang.String getImplementationVersion()
	{
		return null;
	}


	/**
	* Returns the title of the specification.
	*
	* @return		the title of the specification
	**/
	 public  static java.lang.String getSpecificationTitle()
	{
		return null;
	}


	/**
	* Returns the specification vendor.
	*
	* @return		the specification vendor
	**/
	 public  static java.lang.String getSpecificationVendor()
	{
		return null;
	}


	/**
	* Returns the specification version.
	*
	* @return		the specification version
	**/
	 public  static java.lang.String getSpecificationVersion()
	{
		return null;
	}


}